/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.scenario.editor.dsl.helpers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.information.AbstractEventOperation;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.Block;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.CombinedFragment;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.Element;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.FoundMessage;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.LostMessage;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.Message;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.Model;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.Operand;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.Participant;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.SequenceMessage;
import org.polarsys.capella.scenario.editor.helper.EmbeddedEditorInstanceHelper;

public class TextualScenarioHelper {
    private static final String TYPE_FE = "FE";
    private static final String TYPE_CE = "CE";

    public static Object getScenarioAllowedExchangesType(EList<Element> elements) {
        boolean _isESScenario = EmbeddedEditorInstanceHelper.isESScenario();
        if (_isESScenario) {
            boolean _isCEScenario = EmbeddedEditorInstanceHelper.isCEScenario();
            if (_isCEScenario) {
                return TYPE_CE;
            }
            boolean _isFEScenario = EmbeddedEditorInstanceHelper.isFEScenario();
            if (_isFEScenario) {
                return TYPE_FE;
            }
            for (Element element : elements) {
                if (element instanceof Message) {
                    Message message = (Message)element;
                    return TextualScenarioHelper.getMessageExchangeType(message);
                }
                if (!(element instanceof CombinedFragment)) continue;
                CombinedFragment combinedFragment = (CombinedFragment)element;
                return TextualScenarioHelper.getScenarioAllowedExchangesType(combinedFragment.getBlock().getBlockElements());
            }
        }
        return null;
    }

    public static Object getMessageExchangeType(Message message) {
        boolean _equals;
        HashSet _newHashSet;
        List exchangesAvailable = EmbeddedEditorInstanceHelper.getExchangeMessages((String)TextualScenarioHelper.getSourceOfMessage(message), (String)TextualScenarioHelper.getTargetOfMessage(message));
        HashSet allowedTypes = _newHashSet = CollectionLiterals.newHashSet();
        for (AbstractEventOperation exchange : exchangesAvailable) {
            String type;
            if (message.getName() == null || !message.getName().equals(CapellaElementExt.getName((EObject)exchange)) || (type = TextualScenarioHelper.getExchangeType((EObject)exchange)) == null) continue;
            allowedTypes.add(type);
        }
        int _size = allowedTypes.size();
        boolean bl = _equals = _size == 1;
        if (_equals) {
            HashSet _converted_allowedTypes = allowedTypes;
            return ((Object[])Conversions.unwrapArray((Object)_converted_allowedTypes, Object.class))[0];
        }
        return null;
    }

    public static Set getAllMessageExchangeType(Message message) {
        HashSet _newHashSet;
        HashSet allowedTypes = _newHashSet = CollectionLiterals.newHashSet();
        List exchangesAvailable = EmbeddedEditorInstanceHelper.getExchangeMessages((String)TextualScenarioHelper.getSourceOfMessage(message), (String)TextualScenarioHelper.getTargetOfMessage(message));
        for (AbstractEventOperation exchange : exchangesAvailable) {
            String type;
            if (message.getName() == null || !message.getName().equals(CapellaElementExt.getName((EObject)exchange)) || (type = TextualScenarioHelper.getExchangeType((EObject)exchange)) == null) continue;
            allowedTypes.add(type);
        }
        return allowedTypes;
    }

    public static String getExchangeType(EObject exchangeElement) {
        if (exchangeElement instanceof ComponentExchange) {
            return TYPE_CE;
        }
        if (exchangeElement instanceof FunctionalExchange) {
            return TYPE_FE;
        }
        return null;
    }

    private static String getSourceOfMessage(Message message) {
        String source = null;
        if (message instanceof SequenceMessage) {
            source = ((SequenceMessage)message).getSource();
        } else if (message instanceof LostMessage) {
            source = ((LostMessage)message).getSource();
        }
        return source;
    }

    private static String getTargetOfMessage(Message message) {
        String target = null;
        if (message instanceof SequenceMessage) {
            target = ((SequenceMessage)message).getTarget();
        } else if (message instanceof FoundMessage) {
            target = ((FoundMessage)message).getTarget();
        }
        return target;
    }

    public static EList<Participant> participantsDefinedBefore(Model rootModel) {
        return rootModel.getParticipants();
    }

    public static ArrayList<String> participantsDefinedBeforeNames(EObject element) {
        ArrayList participantsNames = CollectionLiterals.newArrayList();
        EObject container = TextualScenarioHelper.getModelContainer(element);
        if (container instanceof Model) {
            Model model = (Model)container;
            EList<Participant> participants = TextualScenarioHelper.participantsDefinedBefore(model);
            for (Participant participant : participants) {
                participantsNames.add(participant.getName());
            }
        }
        return participantsNames;
    }

    public static boolean isParticipantKeyword(String keywordValue) {
        List participantsKeywords = EmbeddedEditorInstanceHelper.PARTICIPANT_KEYWORDS;
        return participantsKeywords.contains(keywordValue);
    }

    public static List<Element> getContainerElements(EObject modelContainer) {
        if (modelContainer instanceof Model) {
            return ((Model)modelContainer).getElements();
        }
        if (modelContainer instanceof CombinedFragment) {
            ArrayList elements = CollectionLiterals.newArrayList();
            elements.addAll(((CombinedFragment)modelContainer).getBlock().getBlockElements());
            EList<Operand> operands = ((CombinedFragment)modelContainer).getOperands();
            for (Operand operand : operands) {
                elements.addAll(operand.getBlock().getBlockElements());
            }
            return elements;
        }
        if (modelContainer instanceof Block) {
            return ((Block)modelContainer).getBlockElements();
        }
        return CollectionLiterals.newArrayList();
    }

    public static List<Element> getAllElements(EObject modelContainer, List<Element> allElements) {
        List<Element> _containerElements = TextualScenarioHelper.getContainerElements(modelContainer);
        for (Element element : _containerElements) {
            if (!(element instanceof CombinedFragment)) {
                allElements.add(element);
                continue;
            }
            allElements.add(element);
            TextualScenarioHelper.getAllElements(element, allElements);
        }
        return allElements;
    }

    public static EObject getModelContainer(EObject object) {
        if (object instanceof Model) {
            return (Model)object;
        }
        if (object != null) {
            return TextualScenarioHelper.getModelContainer(object.eContainer());
        }
        return null;
    }

    public static EObject getDirectContainer(EObject element) {
        if (element != null) {
            EObject container = element.eContainer();
            if (container instanceof Model || container instanceof CombinedFragment) {
                return container;
            }
            return TextualScenarioHelper.getDirectContainer(container);
        }
        return null;
    }
}

