/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.transition.system2subsystem.tests.mixed;

import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.ecore.EObject;
import org.junit.Assert;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.transition.system2subsystem.tests.AbstractSystem2SubsystemTest;
import org.polarsys.capella.transition.system2subsystem.tests.System2SubsystemTest;
import org.polarsys.capella.transition.system2subsystem.tests.TraceabilityArchitectureSID;
import org.polarsys.capella.transition.system2subsystem.tests.multiphases.MultiPhasesTest;

public class CopyImagesAndUpdatePathsTest {
    private static final String ID_PC1 = "92e20a23-fb3f-45d8-aa2f-8aaecdafa7b4";
    private static final String ID_LC1 = "8da8b3c5-9ed3-4bf7-93da-f53cc4ba95ab";
    private static final String COPIED_IMAGE_PATH = "images/Capella128x128.png";
    private static final String COPIED_LIB_IMAGE_PATH = "output_lib/images/Capella64x64.png";

    CopyImagesAndUpdatePathsTest() {
    }

    public static void testImageCopy(String sourceProjectName, String targetProjectName, EObject targetObject) {
        IFile copiedImage = ResourcesPlugin.getWorkspace().getRoot().getProject(targetProjectName).getFile(COPIED_IMAGE_PATH);
        Assert.assertTrue((String)"An image file should have been copied", (boolean)copiedImage.exists());
        Assert.assertTrue((String)"Target Object is a Capella element", (boolean)(targetObject instanceof CapellaElement));
        boolean containsExpectedModifiedPath = ((CapellaElement)targetObject).getDescription().contains(String.valueOf(targetProjectName) + "/" + COPIED_IMAGE_PATH);
        boolean containsOriginalPath = ((CapellaElement)targetObject).getDescription().contains(String.valueOf(sourceProjectName) + "/" + COPIED_IMAGE_PATH);
        boolean containsOriginalLibPath = ((CapellaElement)targetObject).getDescription().contains(COPIED_LIB_IMAGE_PATH);
        Assert.assertTrue((String)"Target Object shall contain the modified image path", (boolean)containsExpectedModifiedPath);
        Assert.assertFalse((String)"Target Object shall not contain the original image path", (boolean)containsOriginalPath);
        Assert.assertTrue((String)"Target Object shall still contain the original lib image path", (boolean)containsOriginalLibPath);
    }

    public static class CopyImagesAndUpdatePathsCrossphasesTest
    extends System2SubsystemTest
    implements System2SubsystemTest.Crossphase {
        @Override
        protected Collection<?> getProjectionElements() {
            return this.getObjects(new String[]{CopyImagesAndUpdatePathsTest.ID_LC1});
        }

        @Override
        protected void verify() throws Exception {
            CopyImagesAndUpdatePathsTest.testImageCopy(this.getRequiredTestModels().get(0), this.getRequiredTestModels().get(1), this.mustBeTransitioned(CopyImagesAndUpdatePathsTest.ID_LC1));
        }
    }

    public static class CopyImagesAndUpdatePathsInterphasesTest
    extends System2SubsystemTest
    implements System2SubsystemTest.Interphase {
        @Override
        protected Collection<?> getProjectionElements() {
            return this.getObjects(new String[]{CopyImagesAndUpdatePathsTest.ID_PC1});
        }

        @Override
        protected void verify() {
            CopyImagesAndUpdatePathsTest.testImageCopy(this.getRequiredTestModels().get(0), this.getRequiredTestModels().get(1), this.mustBeTransitioned(CopyImagesAndUpdatePathsTest.ID_PC1));
        }
    }

    public static class CopyImagesAndUpdatePathsMultiphasesTest
    extends MultiPhasesTest {
        @Override
        protected Collection<?> getProjectionElements() {
            return this.getObjects(new String[]{CopyImagesAndUpdatePathsTest.ID_PC1});
        }

        @Override
        protected void verify() throws Exception {
            ((TraceabilityArchitectureSID)this.traceability).setArchitecture(BlockArchitectureExt.Type.SA);
            CopyImagesAndUpdatePathsTest.testImageCopy(this.getRequiredTestModels().get(0), this.getRequiredTestModels().get(1), this.mustBeTransitioned(CopyImagesAndUpdatePathsTest.ID_PC1, AbstractSystem2SubsystemTest.ComponentType.SYSTEM));
            ((TraceabilityArchitectureSID)this.traceability).setArchitecture(BlockArchitectureExt.Type.LA);
            CopyImagesAndUpdatePathsTest.testImageCopy(this.getRequiredTestModels().get(0), this.getRequiredTestModels().get(1), this.mustBeTransitioned(CopyImagesAndUpdatePathsTest.ID_PC1, AbstractSystem2SubsystemTest.ComponentType.LOGICAL_COMPONENT));
            ((TraceabilityArchitectureSID)this.traceability).setArchitecture(BlockArchitectureExt.Type.PA);
            CopyImagesAndUpdatePathsTest.testImageCopy(this.getRequiredTestModels().get(0), this.getRequiredTestModels().get(1), this.mustBeTransitioned(CopyImagesAndUpdatePathsTest.ID_PC1));
        }
    }
}

