/*
 * Decompiled with CFR 0.152.
 */
package com.gradleware.tooling.toolingmodel.repository.internal;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.gradleware.tooling.toolingmodel.OmniBuildInvocations;
import com.gradleware.tooling.toolingmodel.OmniBuildInvocationsContainer;
import com.gradleware.tooling.toolingmodel.OmniGradleProject;
import com.gradleware.tooling.toolingmodel.OmniGradleScript;
import com.gradleware.tooling.toolingmodel.OmniProjectTask;
import com.gradleware.tooling.toolingmodel.OmniTaskSelector;
import com.gradleware.tooling.toolingmodel.Path;
import com.gradleware.tooling.toolingmodel.repository.internal.DefaultOmniBuildInvocationsContainer;
import com.gradleware.tooling.toolingmodel.repository.internal.DefaultOmniBuildInvocationsContainerBuilder;
import com.gradleware.tooling.toolingmodel.repository.internal.DefaultOmniGradleScript;
import com.gradleware.tooling.toolingmodel.repository.internal.HierarchyHelper;
import com.gradleware.tooling.toolingmodel.util.Maybe;
import java.io.File;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.gradle.api.specs.Spec;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.ProjectIdentifier;
import org.gradle.tooling.model.gradle.GradleScript;

public final class DefaultOmniGradleProject
implements OmniGradleProject {
    private final HierarchyHelper<OmniGradleProject> hierarchyHelper;
    private String name;
    private String description;
    private Path path;
    private Maybe<File> projectDirectory;
    private ProjectIdentifier projectIdentifier;
    private Maybe<File> buildDirectory;
    private Maybe<OmniGradleScript> buildScript;
    private ImmutableList<OmniProjectTask> projectTasks;
    private ImmutableList<OmniTaskSelector> taskSelectors;

    private DefaultOmniGradleProject(Comparator<? super OmniGradleProject> comparator) {
        this.hierarchyHelper = new HierarchyHelper<DefaultOmniGradleProject>(this, (Comparator)Preconditions.checkNotNull(comparator));
    }

    @Override
    public String getName() {
        return this.name;
    }

    private void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    private void setPath(Path path) {
        this.path = path;
    }

    @Override
    public Maybe<File> getProjectDirectory() {
        return this.projectDirectory;
    }

    private void setProjectDirectory(Maybe<File> projectDirectory) {
        this.projectDirectory = projectDirectory;
    }

    @Override
    public ProjectIdentifier getProjectIdentifier() {
        return this.projectIdentifier;
    }

    private void setProjectIdentifier(ProjectIdentifier projectIdentifier) {
        this.projectIdentifier = projectIdentifier;
    }

    @Override
    public Maybe<File> getBuildDirectory() {
        return this.buildDirectory;
    }

    public void setBuildDirectory(Maybe<File> buildDirectory) {
        this.buildDirectory = buildDirectory;
    }

    @Override
    public Maybe<OmniGradleScript> getBuildScript() {
        return this.buildScript;
    }

    public void setBuildScript(Maybe<OmniGradleScript> buildScript) {
        this.buildScript = buildScript;
    }

    public ImmutableList<OmniProjectTask> getProjectTasks() {
        return this.projectTasks;
    }

    public void setProjectTasks(List<OmniProjectTask> projectTasks) {
        this.projectTasks = ImmutableList.copyOf(projectTasks);
    }

    public ImmutableList<OmniTaskSelector> getTaskSelectors() {
        return this.taskSelectors;
    }

    public void setTaskSelectors(List<OmniTaskSelector> taskSelectors) {
        this.taskSelectors = ImmutableList.copyOf(taskSelectors);
    }

    @Override
    public OmniGradleProject getRoot() {
        return this.hierarchyHelper.getRoot();
    }

    @Override
    public OmniGradleProject getParent() {
        return this.hierarchyHelper.getParent();
    }

    private void setParent(DefaultOmniGradleProject parent) {
        this.hierarchyHelper.setParent(parent);
    }

    @Override
    public ImmutableList<OmniGradleProject> getChildren() {
        return this.hierarchyHelper.getChildren();
    }

    private void addChild(DefaultOmniGradleProject child) {
        child.setParent(this);
        this.hierarchyHelper.addChild(child);
    }

    @Override
    public ImmutableList<OmniGradleProject> getAll() {
        return this.hierarchyHelper.getAll();
    }

    @Override
    public ImmutableList<OmniGradleProject> filter(Spec<? super OmniGradleProject> predicate) {
        return this.hierarchyHelper.filter(predicate);
    }

    @Override
    public Optional<OmniGradleProject> tryFind(Spec<? super OmniGradleProject> predicate) {
        return this.hierarchyHelper.tryFind(predicate);
    }

    public static DefaultOmniGradleProject from(GradleProject project) {
        return DefaultOmniGradleProject.from(project, Maps.newHashMap());
    }

    public static DefaultOmniGradleProject from(GradleProject project, Map<ProjectIdentifier, DefaultOmniGradleProject> knownProjects) {
        DefaultOmniBuildInvocationsContainer buildInvocationsContainer = DefaultOmniBuildInvocationsContainerBuilder.build(project);
        return DefaultOmniGradleProject.convert(project, buildInvocationsContainer, knownProjects);
    }

    private static DefaultOmniGradleProject convert(GradleProject project, OmniBuildInvocationsContainer buildInvocationsContainer, Map<ProjectIdentifier, DefaultOmniGradleProject> knownProjects) {
        ProjectIdentifier id = project.getProjectIdentifier();
        if (knownProjects.containsKey(id)) {
            return knownProjects.get(id);
        }
        DefaultOmniGradleProject gradleProject = new DefaultOmniGradleProject(OmniGradleProjectComparator.INSTANCE);
        knownProjects.put(id, gradleProject);
        gradleProject.setName(project.getName());
        gradleProject.setDescription(project.getDescription());
        gradleProject.setPath(Path.from(project.getPath()));
        gradleProject.setProjectIdentifier(project.getProjectIdentifier());
        DefaultOmniGradleProject.setProjectDirectory(gradleProject, project);
        DefaultOmniGradleProject.setBuildDirectory(gradleProject, project);
        DefaultOmniGradleProject.setBuildScript(gradleProject, project);
        OmniBuildInvocations buildInvocations = (OmniBuildInvocations)buildInvocationsContainer.asMap().get(Path.from(project.getPath()));
        gradleProject.setProjectTasks(buildInvocations.getProjectTasks());
        gradleProject.setTaskSelectors(buildInvocations.getTaskSelectors());
        for (GradleProject child : project.getChildren()) {
            DefaultOmniGradleProject gradleProjectChild = DefaultOmniGradleProject.convert(child, buildInvocationsContainer, knownProjects);
            gradleProject.addChild(gradleProjectChild);
        }
        return gradleProject;
    }

    private static void setProjectDirectory(DefaultOmniGradleProject gradleProject, GradleProject project) {
        try {
            File projectDirectory = project.getProjectDirectory();
            gradleProject.setProjectDirectory(Maybe.of(projectDirectory));
        }
        catch (Exception ignore) {
            gradleProject.setProjectDirectory(Maybe.<File>absent());
        }
    }

    private static void setBuildDirectory(DefaultOmniGradleProject gradleProject, GradleProject project) {
        try {
            File buildDirectory = project.getBuildDirectory();
            gradleProject.setBuildDirectory(Maybe.of(buildDirectory));
        }
        catch (Exception ignore) {
            gradleProject.setBuildDirectory(Maybe.<File>absent());
        }
    }

    private static void setBuildScript(DefaultOmniGradleProject gradleProject, GradleProject project) {
        try {
            GradleScript buildScript = project.getBuildScript();
            gradleProject.setBuildScript(Maybe.of(DefaultOmniGradleScript.from(buildScript)));
        }
        catch (Exception ignore) {
            gradleProject.setBuildScript(Maybe.<OmniGradleScript>absent());
        }
    }

    private static enum OmniGradleProjectComparator implements Comparator<OmniGradleProject>
    {
        INSTANCE;


        @Override
        public int compare(OmniGradleProject o1, OmniGradleProject o2) {
            return o1.getPath().compareTo(o2.getPath());
        }
    }
}

