/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.view.task;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.gradleware.tooling.toolingmodel.OmniProjectTask;
import org.eclipse.buildship.ui.view.task.ProjectNode;
import org.eclipse.buildship.ui.view.task.TaskNode;

public final class ProjectTaskNode
implements TaskNode {
    private final ProjectNode parentProjectNode;
    private final OmniProjectTask projectTask;

    public ProjectTaskNode(ProjectNode parentProjectNode, OmniProjectTask projectTask) {
        this.parentProjectNode = (ProjectNode)Preconditions.checkNotNull((Object)parentProjectNode);
        this.projectTask = (OmniProjectTask)Preconditions.checkNotNull((Object)projectTask);
    }

    @Override
    public ProjectNode getParentProjectNode() {
        return this.parentProjectNode;
    }

    public OmniProjectTask getProjectTask() {
        return this.projectTask;
    }

    @Override
    public String getName() {
        return this.projectTask.getName();
    }

    @Override
    public TaskNode.TaskNodeType getType() {
        return TaskNode.TaskNodeType.PROJECT_TASK_NODE;
    }

    @Override
    public boolean isPublic() {
        return this.projectTask.isPublic();
    }

    public String toString() {
        return this.projectTask.getName();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ProjectTaskNode that = (ProjectTaskNode)other;
        return Objects.equal((Object)this.parentProjectNode, (Object)that.parentProjectNode) && Objects.equal((Object)this.projectTask, (Object)that.projectTask);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.parentProjectNode, this.projectTask});
    }
}

