/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.preferences;

import java.io.File;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class LibraryPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private List LibraryList;
    private Label labelTitle;
    private Button addButton;
    private Button removeButton;
    private Button removeAllButton;
    private String[] extensions = new String[]{Messages.getString((String)"report.designer.ui.preferences.extensions")};
    private String openDialogTitle = Messages.getString((String)"report.designer.ui.preferences.dialogtitle");
    private static final String EXPORT_PREF_TITLE = Messages.getString((String)"report.designer.ui.preferences.library.export.title");
    private static final String EXPORT_PREF_ALWAYS = Messages.getString((String)"report.designer.ui.preferences.library.export.overwrite.always");
    private static final String EXPORT_PREF_NEVER = Messages.getString((String)"report.designer.ui.preferences.library.export.overwrite.never");
    private static final String EXPORT_PREF_PROMPT = Messages.getString((String)"report.designer.ui.preferences.library.export.overwrite.prompt");
    private int exportPref;

    public LibraryPreferencePage() {
        this.noDefaultAndApplyButton();
    }

    public LibraryPreferencePage(String title) {
        super(title);
    }

    public LibraryPreferencePage(String title, ImageDescriptor image) {
        super(title, image);
    }

    protected Control createContents(Composite parent) {
        UIUtil.bindHelp((Control)parent, "org.eclipse.birt.cshelp.Preference_BIRT_Library_ID");
        Composite mainComposite = new Composite(parent, 0);
        GridData data = new GridData(1808);
        data.grabExcessHorizontalSpace = false;
        mainComposite.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        mainComposite.setLayout((Layout)layout);
        this.labelTitle = new Label(mainComposite, 0);
        this.labelTitle.setText(Messages.getString((String)"report.designer.ui.preferences.labeltitle"));
        new Label(mainComposite, 0);
        int listStyle = 35588;
        this.LibraryList = new List(mainComposite, listStyle);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.heightHint = 80;
        data.widthHint = 250;
        this.LibraryList.setLayoutData((Object)data);
        this.LibraryList.setItems(ReportPlugin.getDefault().getLibraryPreference());
        this.LibraryList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LibraryPreferencePage.this.removeButton.setEnabled(true);
            }
        });
        Composite buttons = new Composite(mainComposite, 0);
        layout = new GridLayout();
        buttons.setLayout((Layout)layout);
        data = new GridData(2);
        data.grabExcessVerticalSpace = true;
        buttons.setLayoutData((Object)data);
        this.addButton = new Button(buttons, 8);
        this.addButton.setText(Messages.getString((String)"report.designer.ui.preferences.buttonadd"));
        data = new GridData(256);
        this.addButton.setLayoutData((Object)data);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog dialog = new FileDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell());
                dialog.setFilterExtensions(LibraryPreferencePage.this.extensions);
                dialog.setText(LibraryPreferencePage.this.openDialogTitle);
                String fileName = dialog.open();
                if (fileName == null) {
                    return;
                }
                if (!new File(fileName).exists()) {
                    ExceptionHandler.openErrorMessageBox(Messages.getString((String)"AddLibraryAction.Error.Title"), Messages.getFormattedString((String)"AddLibraryAction.Error.FileNotFound", (Object[])new String[]{fileName}));
                    return;
                }
                if (!fileName.endsWith(".rptlibrary")) {
                    ExceptionHandler.openErrorMessageBox(Messages.getString((String)"AddLibraryAction.Error.Title"), Messages.getFormattedString((String)"AddLibraryAction.Error.FileIsNotLibrary", (Object[])new String[]{fileName, ".rptlibrary"}));
                    return;
                }
                if (LibraryPreferencePage.this.LibraryList.indexOf(fileName) == -1) {
                    LibraryPreferencePage.this.LibraryList.add(fileName, LibraryPreferencePage.this.LibraryList.getItemCount());
                    LibraryPreferencePage.this.removeAllButton.setEnabled(true);
                } else {
                    MessageBox msgBox = new MessageBox(PlatformUI.getWorkbench().getDisplay().getActiveShell(), 1);
                    msgBox.setText(Messages.getString((String)"report.designer.ui.preferences.errortitle"));
                    msgBox.setMessage(Messages.getString((String)"report.designer.ui.preferences.errormessage"));
                    msgBox.open();
                }
            }
        });
        this.removeButton = new Button(buttons, 8);
        this.removeButton.setText(Messages.getString((String)"report.designer.ui.preferences.buttonremove"));
        data = new GridData(256);
        this.removeButton.setLayoutData((Object)data);
        this.removeButton.setEnabled(false);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int index = LibraryPreferencePage.this.LibraryList.getSelectionIndex();
                LibraryPreferencePage.this.LibraryList.remove(index);
                if (LibraryPreferencePage.this.LibraryList.getItemCount() <= 0) {
                    LibraryPreferencePage.this.removeButton.setEnabled(false);
                    LibraryPreferencePage.this.removeAllButton.setEnabled(false);
                } else if (LibraryPreferencePage.this.LibraryList.getItemCount() > 0) {
                    if (index >= LibraryPreferencePage.this.LibraryList.getItemCount()) {
                        --index;
                    }
                    LibraryPreferencePage.this.LibraryList.setSelection(index);
                    LibraryPreferencePage.this.removeButton.setEnabled(true);
                }
            }
        });
        this.removeAllButton = new Button(buttons, 8);
        this.removeAllButton.setText(Messages.getString((String)"report.designer.ui.preferences.buttonremoveall"));
        data = new GridData(256);
        this.removeAllButton.setLayoutData((Object)data);
        if (this.LibraryList.getItemCount() <= 0) {
            this.removeAllButton.setEnabled(false);
        }
        this.removeAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LibraryPreferencePage.this.LibraryList.removeAll();
                LibraryPreferencePage.this.removeButton.setEnabled(false);
                LibraryPreferencePage.this.removeAllButton.setEnabled(false);
            }
        });
        this.exportPref = ReportPlugin.getDefault().getPreferenceStore().getInt("ExportToLibraryAction.Pref");
        Group optionGroup = new Group(parent, 0);
        optionGroup.setText(EXPORT_PREF_TITLE);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        gridLayout.marginWidth = 15;
        gridLayout.marginHeight = 15;
        optionGroup.setLayout((Layout)gridLayout);
        optionGroup.setLayoutData((Object)new GridData(768));
        Button alwaysButton = new Button((Composite)optionGroup, 16);
        alwaysButton.setText(EXPORT_PREF_ALWAYS);
        alwaysButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                LibraryPreferencePage.this.exportPref = 1;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                LibraryPreferencePage.this.exportPref = 1;
            }
        });
        alwaysButton.setSelection(this.exportPref == 1);
        Button neverButton = new Button((Composite)optionGroup, 16);
        neverButton.setText(EXPORT_PREF_NEVER);
        neverButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                LibraryPreferencePage.this.exportPref = 2;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                LibraryPreferencePage.this.exportPref = 2;
            }
        });
        neverButton.setSelection(this.exportPref == 2);
        Button promptButton = new Button((Composite)optionGroup, 16);
        promptButton.setText(EXPORT_PREF_PROMPT);
        promptButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                LibraryPreferencePage.this.exportPref = 0;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                LibraryPreferencePage.this.exportPref = 0;
            }
        });
        promptButton.setSelection(this.exportPref == 0);
        return mainComposite;
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(ReportPlugin.getDefault().getPreferenceStore());
    }

    protected void performDefaults() {
        this.LibraryList.setItems(ReportPlugin.getDefault().getDefaultLibraryPreference());
        this.removeButton.setEnabled(false);
        if (this.LibraryList.getItemCount() <= 0) {
            this.removeAllButton.setEnabled(false);
        }
    }

    public boolean performOk() {
        ReportPlugin.getDefault().setLibraryPreference(this.LibraryList.getItems());
        ReportPlugin.getDefault().getPreferenceStore().setValue("ExportToLibraryAction.Pref", this.exportPref);
        return super.performOk();
    }
}

