/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.ide.ui.dialog;

import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class EObjectViewerFilter
extends ViewerFilter {
    private final Set<EStructuralFeature> containingFeatures;
    private final Set<EClass> acceptedClasses;

    public EObjectViewerFilter(Set<EStructuralFeature> containingFeatures, Set<EClass> acceptedClasses) {
        this.containingFeatures = containingFeatures;
        this.acceptedClasses = acceptedClasses;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        boolean res;
        if (element instanceof Resource) {
            Resource resource = (Resource)element;
            res = this.canContainsOrHas(resource);
        } else {
            EStructuralFeature containingFeature;
            res = element instanceof EObject ? (containingFeature = ((EObject)element).eContainingFeature()) == null || this.containingFeatures.contains(containingFeature) || ((EObject)element).eContainer() instanceof Resource : false;
        }
        return res;
    }

    private boolean canContainsOrHas(Resource resource) {
        boolean res = false;
        block0: for (EObject content : resource.getContents()) {
            if (this.isInstanceOfAny(content, this.acceptedClasses)) {
                res = true;
                break;
            }
            for (EReference reference : content.eClass().getEAllReferences()) {
                if (!this.containingFeatures.contains(reference)) continue;
                res = true;
                break block0;
            }
        }
        return res;
    }

    private boolean isInstanceOfAny(EObject eObj, Set<EClass> eClasses) {
        boolean res = false;
        for (EClass eCls : eClasses) {
            if (!eCls.isInstance((Object)eObj)) continue;
            res = true;
            break;
        }
        return res;
    }
}

