/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.search;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.data.AnyDerivedType;
import org.eclipse.fordiac.ide.model.data.ArrayType;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.helpers.PackageNameHelper;
import org.eclipse.fordiac.ide.model.libraryElement.Algorithm;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.AttributeDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.BaseFBType;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.CompositeFBType;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableFB;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.FunctionBody;
import org.eclipse.fordiac.ide.model.libraryElement.FunctionFBType;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.Method;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.STAlgorithm;
import org.eclipse.fordiac.ide.model.libraryElement.STFunctionBody;
import org.eclipse.fordiac.ide.model.libraryElement.STMethod;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.TypedConfigureableObject;
import org.eclipse.fordiac.ide.model.libraryElement.Value;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.search.CompositeMatcher;
import org.eclipse.fordiac.ide.model.search.GlobalConstantsMatcher;
import org.eclipse.fordiac.ide.model.search.IModelMatcher;
import org.eclipse.fordiac.ide.model.search.ISearchContext;
import org.eclipse.fordiac.ide.model.search.ISearchFactory;
import org.eclipse.fordiac.ide.model.search.ISearchSupport;
import org.eclipse.fordiac.ide.model.search.LiveSearchContext;
import org.eclipse.fordiac.ide.model.search.Match;
import org.eclipse.fordiac.ide.model.search.Messages;
import org.eclipse.fordiac.ide.model.search.ModelQuerySpec;
import org.eclipse.fordiac.ide.model.search.ModelSearchPattern;
import org.eclipse.fordiac.ide.model.search.ModelSearchResult;
import org.eclipse.fordiac.ide.model.search.STMatcher;
import org.eclipse.fordiac.ide.model.search.TextMatch;
import org.eclipse.fordiac.ide.model.search.types.GlobalConstantsTypeInstanceSearch;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarDeclaration;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search2.internal.ui.SearchView;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ModelSearchQuery
implements ISearchQuery {
    private final ModelQuerySpec modelQuerySpec;
    private final ModelSearchPattern pattern;
    private ModelSearchResult searchResult;
    private boolean isIncompleteResult = false;

    public ModelSearchQuery(ModelQuerySpec modelQuerySpec) {
        this.modelQuerySpec = modelQuerySpec;
        this.pattern = new ModelSearchPattern(modelQuerySpec);
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        this.getSearchResult().clear();
        List<ISearchContext> searchRootSystems = this.getSearchContexts();
        try {
            this.performSearch(searchRootSystems, monitor);
        }
        catch (SearchCanceledException e) {
            return Status.CANCEL_STATUS;
        }
        Display.getDefault().asyncExec(() -> ((SearchView)NewSearchUI.getSearchResultView()).showSearchResult((ISearchResult)this.getSearchResult()));
        if (this.isIncompleteResult) {
            Display.getDefault().asyncExec(() -> MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.STSearchErrorDialog_Title, (String)Messages.STSearchErrorDialog_Body));
        }
        return Status.OK_STATUS;
    }

    private List<ISearchContext> getSearchContexts() {
        if (this.modelQuerySpec.scope() == ModelQuerySpec.SearchScope.PROJECT && this.modelQuerySpec.project() != null) {
            return Arrays.asList(new LiveSearchContext(this.modelQuerySpec.project()));
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        return Arrays.stream(root.getProjects()).filter(IProject::isOpen).map(LiveSearchContext::new).map(ISearchContext.class::cast).toList();
    }

    private void performSearch(List<ISearchContext> searchContexts, IProgressMonitor monitor) {
        for (ISearchContext context : searchContexts) {
            context.getTypes().forEach(libraryElementURI -> {
                EObject eObject = context.mapTypes((URI)libraryElementURI);
                if (eObject instanceof LibraryElement) {
                    LibraryElement libraryElement = (LibraryElement)eObject;
                    if (libraryElement instanceof AutomationSystem) {
                        AutomationSystem sys = (AutomationSystem)libraryElement;
                        this.searchSystem(sys, monitor);
                    } else if (this.matchTypeEntry(libraryElement, monitor)) {
                        this.searchResult.addResult((EObject)libraryElement);
                    }
                } else {
                    FordiacLogHelper.logWarning((String)("Could not load model for: " + libraryElementURI.toString()));
                }
            });
        }
    }

    private void searchSystem(AutomationSystem sys, IProgressMonitor monitor) {
        for (Application app : sys.getApplication()) {
            this.searchApplication(app, monitor);
        }
        this.searchResources(sys, monitor);
    }

    @Deprecated
    public void searchApplication(Application app) {
        this.searchApplication(app, null);
    }

    private void searchApplication(Application app, IProgressMonitor monitor) {
        if (this.matchEObject((INamedElement)app, monitor)) {
            this.searchResult.addResult((EObject)app);
        }
        this.searchFBNetwork(app.getFBNetwork(), new ArrayList<FBNetworkElement>(), monitor);
    }

    private void searchFBNetwork(FBNetwork network, List<FBNetworkElement> path, IProgressMonitor monitor) {
        for (FBNetworkElement fbnetworkElement : network.getNetworkElements()) {
            List<IInterfaceElement> matchingPins;
            BlockFBNetworkElement bfbne;
            SubApp subApp;
            ConfigurableFB conf;
            FBType fBType;
            if (this.matchEObject((INamedElement)fbnetworkElement, monitor)) {
                if (!path.isEmpty()) {
                    this.searchResult.getDictionary().addEntry(fbnetworkElement, path);
                }
                this.searchResult.addResult((EObject)fbnetworkElement);
            }
            if ((fBType = fbnetworkElement.getType()) instanceof BaseFBType) {
                BaseFBType type = (BaseFBType)fBType;
                for (FB fb : type.getInternalFbs()) {
                    if (!this.matchEObject((INamedElement)fb, monitor)) continue;
                    this.searchResult.getDictionary().addEntry((FBNetworkElement)fb, ModelSearchQuery.allocatePathList(path, fbnetworkElement));
                    this.searchResult.addResult((EObject)fb);
                }
            }
            if (fbnetworkElement instanceof ConfigurableFB && this.matchEObject((INamedElement)(conf = (ConfigurableFB)fbnetworkElement).getDataType(), monitor)) {
                this.searchResult.addResult((EObject)conf);
            }
            if (fbnetworkElement instanceof SubApp && !(subApp = (SubApp)fbnetworkElement).isTyped() && subApp.getSubAppNetwork() != null) {
                this.searchFBNetwork(subApp.getSubAppNetwork(), path, monitor);
            }
            if (!(fbnetworkElement instanceof BlockFBNetworkElement) || (bfbne = (BlockFBNetworkElement)fbnetworkElement).getInterface() == null) continue;
            if (this.modelQuerySpec.checkPinName() && !(matchingPins = bfbne.getInterface().getAllInterfaceElements().stream().filter(pin -> pin.getName() != null && this.compareStrings(pin.getName())).toList()).isEmpty()) {
                if (!path.isEmpty()) {
                    this.searchResult.getDictionary().addEntry(fbnetworkElement, path);
                }
                this.searchResult.addResults(matchingPins);
            }
            if (!this.modelQuerySpec.checkType()) continue;
            this.searchInterface(bfbne.getInterface(), monitor);
        }
    }

    private static List<FBNetworkElement> allocatePathList(List<FBNetworkElement> path, FBNetworkElement elem) {
        ArrayList<FBNetworkElement> list = new ArrayList<FBNetworkElement>(path);
        list.add(elem);
        return list;
    }

    private void searchResources(AutomationSystem sys, IProgressMonitor monitor) {
        for (Device dev : sys.getSystemConfiguration().getDevices()) {
            if (this.matchEObject((INamedElement)dev, monitor)) {
                this.searchResult.addResult((EObject)dev);
            }
            for (Resource res : dev.getResource()) {
                if (!this.matchEObject((INamedElement)res, monitor)) continue;
                this.searchResult.addResult((EObject)res);
            }
        }
    }

    private boolean matchTypeEntry(LibraryElement elem, IProgressMonitor monitor) {
        FBType type;
        LibraryElement libraryElement = elem;
        Objects.requireNonNull(libraryElement);
        LibraryElement libraryElement2 = libraryElement;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CompositeFBType.class, BaseFBType.class, ArrayType.class, StructuredType.class, AttributeDeclaration.class}, (Object)libraryElement2, 0)) {
            case 0: {
                CompositeFBType comp = (CompositeFBType)libraryElement2;
                this.searchFBNetwork(comp.getFBNetwork(), new ArrayList<FBNetworkElement>(), monitor);
                break;
            }
            case 1: {
                BaseFBType type2 = (BaseFBType)libraryElement2;
                for (FB fb : type2.getInternalFbs()) {
                    if (!this.matchEObject((INamedElement)fb, monitor)) continue;
                    this.searchResult.addResult((EObject)fb);
                }
                for (VarDeclaration varDecl : type2.getInternalVars()) {
                    if (!this.matchEObject((INamedElement)varDecl, monitor)) continue;
                    this.searchResult.addResult((EObject)varDecl);
                }
                for (Algorithm algo : type2.getAlgorithm()) {
                    if (!this.matchEObject((INamedElement)algo, monitor)) continue;
                    this.searchResult.addResult((EObject)algo);
                }
                for (Method meth : type2.getMethods()) {
                    if (!this.matchEObject((INamedElement)meth, monitor)) continue;
                    this.searchResult.addResult((EObject)meth);
                }
                break;
            }
            case 2: {
                ArrayType array = (ArrayType)libraryElement2;
                DataType base = array.getBaseType();
                if (!this.matchEObject((INamedElement)base, monitor)) break;
                this.searchResult.addResult((EObject)base);
                break;
            }
            case 3: {
                StructuredType struct = (StructuredType)libraryElement2;
                this.matchStruct(struct, monitor);
                break;
            }
            case 4: {
                AttributeDeclaration attDecl = (AttributeDeclaration)libraryElement2;
                AnyDerivedType anyDerivedType = attDecl.getType();
                if (anyDerivedType instanceof StructuredType) {
                    StructuredType struct = (StructuredType)anyDerivedType;
                    this.matchStruct(struct, monitor);
                    break;
                }
                if (!this.matchEObject((INamedElement)attDecl.getType(), monitor)) break;
                this.searchResult.addResult((EObject)attDecl.getType());
                break;
            }
        }
        if (elem instanceof FBType && (type = (FBType)elem).getInterfaceList() != null) {
            this.searchTypeInterface(type.getInterfaceList(), monitor);
        }
        return this.matchEObject((INamedElement)elem, monitor);
    }

    private void matchStruct(StructuredType struct, IProgressMonitor monitor) {
        for (VarDeclaration varDecl : struct.getMemberVariables()) {
            if (varDecl.isArray()) {
                if (!this.matchEObject((INamedElement)varDecl.getType(), monitor)) continue;
                this.searchResult.addResult((EObject)varDecl);
                continue;
            }
            if (!this.matchEObject((INamedElement)varDecl, monitor)) continue;
            this.searchResult.addResult((EObject)varDecl);
        }
    }

    private void searchTypeInterface(InterfaceList interfaceList, IProgressMonitor monitor) {
        Stream.of(interfaceList.getInputs(), interfaceList.getOutputVars().stream(), interfaceList.getEventOutputs().stream(), interfaceList.getPlugs().stream()).flatMap(Function.identity()).filter(modelElement -> this.modelQuerySpec.checkInterfaceValues() && this.searchInterfaceValue((INamedElement)modelElement) || this.matchEObject((INamedElement)modelElement, monitor)).forEach(this.searchResult::addResult);
    }

    private boolean searchInterfaceValue(INamedElement modelElement) {
        if (modelElement instanceof VarDeclaration) {
            VarDeclaration varDecl = (VarDeclaration)modelElement;
            Value value = varDecl.getValue();
            return value != null && !value.getValue().isEmpty() && value.getValue().contains(this.modelQuerySpec.searchString());
        }
        return false;
    }

    private void searchInterface(InterfaceList interfaceList, IProgressMonitor monitor) {
        Stream searchableElements = Stream.of(interfaceList.getInputs(), interfaceList.getOutputVars().stream(), interfaceList.getEventOutputs().stream(), interfaceList.getPlugs().stream()).flatMap(Function.identity());
        searchableElements.filter(modelElement -> this.matchEObject((INamedElement)modelElement, monitor)).forEach(this.searchResult::addResult);
    }

    private boolean matchEObject(INamedElement modelElement, IProgressMonitor monitor) {
        SearchCanceledException.throwIfCanceled(monitor);
        if (this.modelQuerySpec.checkInstanceName()) {
            boolean matchInstanceName;
            String name = modelElement.getName();
            boolean bl = matchInstanceName = name != null && this.compareStrings(name);
            if (matchInstanceName) {
                if (modelElement instanceof Algorithm || modelElement instanceof Method || modelElement instanceof FunctionFBType) {
                    this.addMatchesForSTOccurance(modelElement);
                }
                return true;
            }
        }
        if (this.modelQuerySpec.checkComments()) {
            boolean matchComment;
            String comment = modelElement.getComment();
            boolean bl = matchComment = comment != null && this.compareStrings(comment);
            if (matchComment) {
                return true;
            }
        }
        if (this.modelQuerySpec.checkType()) {
            if (modelElement instanceof Algorithm || modelElement instanceof Method || modelElement instanceof FunctionFBType) {
                this.addMatchesForSTOccurance(modelElement);
                return this.searchResult.hasFordiacMatch(EcoreUtil.getURI((EObject)modelElement));
            }
            if (modelElement instanceof TypedConfigureableObject) {
                TypedConfigureableObject config = (TypedConfigureableObject)modelElement;
                if (this.modelQuerySpec.referenceObject() != null) {
                    String packageName = PackageNameHelper.getPackageNameFromURI((URI)this.modelQuerySpec.referenceObject().eResource().getURI());
                    if (config.getTypeEntry() != null && !packageName.equals(config.getTypeEntry().getPackageName())) {
                        return false;
                    }
                }
                return this.compareStrings(config.getTypeName()) || config.getTypeEntry() != null && this.compareStrings(config.getTypeEntry().getFullTypeName());
            }
            if (modelElement instanceof LibraryElement) {
                LibraryElement namElem = (LibraryElement)modelElement;
                return this.compareStrings(namElem.getName()) || namElem.getTypeEntry() != null && this.compareStrings(namElem.getTypeEntry().getFullTypeName());
            }
            if (modelElement instanceof VarDeclaration) {
                GlobalConstantsMatcher globalConstMatcher;
                VarDeclaration varDecl = (VarDeclaration)modelElement;
                if (this.modelQuerySpec.referenceObject() instanceof STVarDeclaration && (globalConstMatcher = this.createGlobalConstMatcher()) != null) {
                    return GlobalConstantsTypeInstanceSearch.createSearchFilter(globalConstMatcher).apply((EObject)varDecl);
                }
                return this.compareStrings(varDecl.getTypeName()) || varDecl.getType() != null && varDecl.getType().getTypeEntry() != null && this.compareStrings(varDecl.getType().getTypeEntry().getFullTypeName());
            }
        }
        return false;
    }

    private void addMatchesForSTOccurance(INamedElement modelElement) {
        FunctionFBType function;
        FunctionBody functionBody;
        ISearchSupport searchSupport = null;
        if (modelElement instanceof FunctionFBType && (functionBody = (function = (FunctionFBType)modelElement).getBody()) instanceof STFunctionBody) {
            STFunctionBody functionBody2 = (STFunctionBody)functionBody;
            searchSupport = ISearchFactory.Registry.INSTANCE.getFactory(STFunctionBody.class).createSearchSupport(functionBody2);
        } else if (modelElement instanceof STAlgorithm) {
            searchSupport = ISearchFactory.Registry.INSTANCE.getFactory(STAlgorithm.class).createSearchSupport(modelElement);
        } else if (modelElement instanceof STMethod) {
            searchSupport = ISearchFactory.Registry.INSTANCE.getFactory(STMethod.class).createSearchSupport(modelElement);
        }
        if (searchSupport != null) {
            GlobalConstantsMatcher globalConstMatcher = this.modelQuerySpec.referenceObject() instanceof STVarDeclaration ? this.createGlobalConstMatcher() : null;
            IModelMatcher matcher = globalConstMatcher != null ? new CompositeMatcher(List.of(new STMatcher(this::compareStrings), globalConstMatcher)) : new STMatcher(this::compareStrings);
            URI target = EcoreUtil.getURI((EObject)modelElement);
            searchSupport.search(matcher).filter(TextMatch.class::isInstance).map(TextMatch.class::cast).map(match -> new TextMatch(target, match.getLine() + 1, match.getOffset(), match.getLength(), match.getType())).forEach(match -> this.searchResult.addFordiacMatch((Match)match));
            this.isIncompleteResult |= searchSupport.isIncompleteResult();
        }
    }

    private GlobalConstantsMatcher createGlobalConstMatcher() {
        ArrayList<String> segments = new ArrayList<String>(List.of(this.modelQuerySpec.searchString().split("::")));
        if (segments.size() < 2) {
            return null;
        }
        String variableName = (String)segments.removeLast();
        String typeName = (String)segments.removeLast();
        String packageName = String.join((CharSequence)"::", segments);
        return new GlobalConstantsMatcher(packageName, typeName, variableName);
    }

    private boolean compareStrings(String toTest) {
        if (toTest == null) {
            return false;
        }
        if (this.pattern.matchSearchString(toTest)) {
            return true;
        }
        if (this.modelQuerySpec.checkExactMatching()) {
            return toTest.equals(this.modelQuerySpec.searchString());
        }
        if (this.modelQuerySpec.checkCaseSensitive()) {
            return toTest.contains(this.modelQuerySpec.searchString());
        }
        return toTest.toLowerCase().contains(this.modelQuerySpec.searchString().toLowerCase());
    }

    public String getLabel() {
        return this.modelQuerySpec.searchString();
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ModelSearchResult getSearchResult() {
        if (this.searchResult == null) {
            this.searchResult = this.createModelSearchResult();
        }
        return this.searchResult;
    }

    protected ModelSearchResult createModelSearchResult() {
        return new ModelSearchResult(this);
    }

    private static class SearchCanceledException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private SearchCanceledException() {
        }

        public static void throwIfCanceled(IProgressMonitor monitor) {
            if (monitor != null && monitor.isCanceled()) {
                throw new SearchCanceledException();
            }
        }
    }
}

