/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.search.st;

import org.eclipse.fordiac.ide.model.data.DirectlyDerivedType;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.ECTransition;
import org.eclipse.fordiac.ide.model.libraryElement.STAlgorithm;
import org.eclipse.fordiac.ide.model.libraryElement.STFunctionBody;
import org.eclipse.fordiac.ide.model.libraryElement.STMethod;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.search.ISearchFactory;
import org.eclipse.fordiac.ide.model.search.ISearchSupport;
import org.eclipse.fordiac.ide.model.search.st.AttributeSearchSupport;
import org.eclipse.fordiac.ide.model.search.st.DirectlyDerivedTypeSearchSupport;
import org.eclipse.fordiac.ide.model.search.st.ECTransitionSearchSupport;
import org.eclipse.fordiac.ide.model.search.st.STAlgorithmSearchSupport;
import org.eclipse.fordiac.ide.model.search.st.STFunctionBodySearchSupport;
import org.eclipse.fordiac.ide.model.search.st.STMethodSearchSupport;
import org.eclipse.fordiac.ide.model.search.st.VarDeclarationSearchSupport;

public class StructuredTextSearchFactory
implements ISearchFactory {
    public ISearchSupport createSearchSupport(Object source) {
        if (source instanceof STAlgorithm) {
            STAlgorithm algorithm = (STAlgorithm)source;
            return new STAlgorithmSearchSupport(algorithm);
        }
        if (source instanceof STMethod) {
            STMethod method = (STMethod)source;
            return new STMethodSearchSupport(method);
        }
        if (source instanceof ECTransition) {
            ECTransition transition = (ECTransition)source;
            return new ECTransitionSearchSupport(transition);
        }
        if (source instanceof STFunctionBody) {
            STFunctionBody functionBody = (STFunctionBody)source;
            return new STFunctionBodySearchSupport(functionBody);
        }
        if (source instanceof VarDeclaration) {
            VarDeclaration varDeclaration = (VarDeclaration)source;
            return new VarDeclarationSearchSupport(varDeclaration);
        }
        if (source instanceof Attribute) {
            Attribute attribute = (Attribute)source;
            return new AttributeSearchSupport(attribute);
        }
        if (source instanceof DirectlyDerivedType) {
            DirectlyDerivedType directlyDerivedType = (DirectlyDerivedType)source;
            return new DirectlyDerivedTypeSearchSupport(directlyDerivedType);
        }
        return null;
    }

    public static void register() {
        StructuredTextSearchFactory factory = new StructuredTextSearchFactory();
        ISearchFactory.Registry.INSTANCE.registerFactory(STAlgorithm.class, (ISearchFactory)factory);
        ISearchFactory.Registry.INSTANCE.registerFactory(ECTransition.class, (ISearchFactory)factory);
        ISearchFactory.Registry.INSTANCE.registerFactory(STMethod.class, (ISearchFactory)factory);
        ISearchFactory.Registry.INSTANCE.registerFactory(STFunctionBody.class, (ISearchFactory)factory);
        ISearchFactory.Registry.INSTANCE.registerFactory(VarDeclaration.class, (ISearchFactory)factory);
        ISearchFactory.Registry.INSTANCE.registerFactory(Attribute.class, (ISearchFactory)factory);
        ISearchFactory.Registry.INSTANCE.registerFactory(DirectlyDerivedType.class, (ISearchFactory)factory);
    }
}

