/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.contracts.model;

import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.contracts.exceptions.GuaranteeTwoEventsExeption;
import org.eclipse.fordiac.ide.contracts.model.Guarantee;
import org.eclipse.fordiac.ide.contracts.model.Interval;
import org.eclipse.fordiac.ide.contracts.model.Reaction;
import org.eclipse.fordiac.ide.contracts.model.helpers.ContractUtils;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;

public class GuaranteeTwoEvents
extends Guarantee {
    private static final int POS_WITHIN = 9;
    private static final int POS_OCCUR = 8;
    private static final int POS_EVENTS = 6;
    private static final int POS_MS = 10;
    private static final int POSITION_OUTPUT_EVENT = 7;
    private static final int POSITION_INPUT_EVENT = 3;
    private static final int POSITION_NO = 10;
    private String secondOutputEvent;

    GuaranteeTwoEvents() {
        throw new UnsupportedOperationException("GuaranteeTwoEvents not Implemented");
    }

    public String getSecondOutputEvent() {
        return this.secondOutputEvent;
    }

    void setSecondOutputEvent(String secondOutputEvent) {
        this.secondOutputEvent = secondOutputEvent;
    }

    static Guarantee createGuaranteeTwoEvents(String line) throws GuaranteeTwoEventsExeption {
        String[] parts = line.split(" ");
        if (!GuaranteeTwoEvents.isCorrectGuarantee(parts)) {
            throw new GuaranteeTwoEventsExeption("Error with Guarantee: " + line);
        }
        GuaranteeTwoEvents guarantee = new GuaranteeTwoEvents();
        guarantee.setInputEvent(parts[3]);
        String[] events = parts[7].split(",");
        guarantee.setSecondOutputEvent(events[1].substring(0, events[1].length() - 1));
        guarantee.setOutputEvent(events[0].substring(1, events[0].length()));
        if (ContractUtils.isInterval(parts, 10, ",")) {
            guarantee.setRangeFromInterval(parts, 10);
            return guarantee;
        }
        guarantee.setTime(new Interval(0, Integer.parseInt(parts[10].substring(0, parts[10].length() - "ms".length()))));
        return guarantee;
    }

    @Override
    boolean isValid() {
        if (!this.hasValidOwner()) {
            return false;
        }
        EList fBNetworkElements = ((SubApp)this.getContract().getOwner()).getSubAppNetwork().getNetworkElements();
        List<SubApp> containedSubapps = fBNetworkElements.parallelStream().filter(ContractUtils::isContractSubapp).map(el -> (SubApp)el).toList();
        List<FB> containedfBs = fBNetworkElements.parallelStream().filter(FB.class::isInstance).map(FB.class::cast).toList();
        return this.hasMatchingEvents((SubApp)this.getContract().getOwner(), containedSubapps, containedfBs);
    }

    private boolean hasMatchingEvents(SubApp subapp, List<SubApp> containedSubapps, List<FB> containedfBs) {
        List<Event> outputNames;
        List<Event> inputNames;
        if (!containedSubapps.isEmpty()) {
            EList inputEvents = subapp.getInterface().getEventInputs();
            EList outputEvents = subapp.getInterface().getEventOutputs();
            inputNames = inputEvents.parallelStream().filter(e -> e.getName().equals(this.getInputEvent())).toList();
            outputNames = outputEvents.parallelStream().filter(e -> e.getName().equals(this.getOutputEvent()) || e.getName().equals(this.secondOutputEvent)).toList();
            if (inputNames.size() == 1 && outputNames.size() == 2) {
                return true;
            }
        }
        if (containedfBs.size() == 1) {
            EList inputFBEvents = containedfBs.get(0).getInterface().getEventInputs();
            EList outputFBEvents = containedfBs.get(0).getInterface().getEventOutputs();
            inputNames = inputFBEvents.parallelStream().filter(e -> e.getName().equals(this.getInputEvent())).toList();
            outputNames = outputFBEvents.parallelStream().filter(e -> e.getName().equals(this.getOutputEvent()) || e.getName().equals(this.secondOutputEvent)).toList();
            if (inputNames.size() == 1 && outputNames.size() == 2) {
                return true;
            }
        }
        return false;
    }

    private static boolean isCorrectGuarantee(String[] parts) {
        if (!Guarantee.hasCorrectBeginning(parts)) {
            return false;
        }
        if (!"events".equals(parts[6])) {
            return false;
        }
        if (!"occur".equals(parts[8])) {
            return false;
        }
        if (!"within".equals(parts[9])) {
            return false;
        }
        return "ms".equals(parts[10].subSequence(ContractUtils.getStartPosition(parts, 10), parts[10].length()));
    }

    @Override
    public String asString() {
        StringBuilder comment = new StringBuilder();
        if (this.getMin() == 0 || this.getMin() == this.getMax()) {
            comment.append(ContractUtils.createGuaranteeTwoEvents(this.getInputEvent(), this.getOutputEvent(), this.getSecondOutputEvent(), String.valueOf(this.getMax())));
        } else {
            comment.append(ContractUtils.createGuaranteeTwoEvents(this.getInputEvent(), this.getOutputEvent(), this.getSecondOutputEvent(), ContractUtils.createInterval(this)));
        }
        comment.append(System.lineSeparator());
        return comment.toString();
    }

    public static boolean isCompatibleWith(Map<String, EList<Guarantee>> mapGuarantees, Map<String, EList<Reaction>> mapReactions, Map<String, EList<GuaranteeTwoEvents>> mapGuaranteeTwoEvents) {
        return mapGuarantees.isEmpty() && mapReactions.isEmpty() && mapGuaranteeTwoEvents.size() == 1;
    }
}

