/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.editparts;

import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.text.FlowPage;
import org.eclipse.draw2d.text.ParagraphTextLayout;
import org.eclipse.draw2d.text.TextFlow;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.fordiac.ide.application.figures.InstanceCommentFigure;
import org.eclipse.fordiac.ide.gef.editparts.AbstractPositionableElementEditPart;
import org.eclipse.fordiac.ide.gef.editparts.FigureCellEditorLocator;
import org.eclipse.fordiac.ide.gef.editparts.TextDirectEditManager;
import org.eclipse.fordiac.ide.gef.policies.AbstractViewRenameEditPolicy;
import org.eclipse.fordiac.ide.model.CoordinateConverter;
import org.eclipse.fordiac.ide.model.commands.change.ChangeCommentCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteFBNetworkElementCommand;
import org.eclipse.fordiac.ide.model.libraryElement.Comment;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.model.libraryElement.Position;
import org.eclipse.fordiac.ide.model.libraryElement.PositionableElement;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;

public class CommentEditPart
extends AbstractPositionableElementEditPart {
    private static final int DOG_EAR_SIZE = 9;

    public Comment getModel() {
        return (Comment)super.getModel();
    }

    protected PositionableElement getPositionableElement() {
        return this.getModel();
    }

    public INamedElement getINamedElement() {
        return this.getModel();
    }

    public Label getNameLabel() {
        return null;
    }

    protected void refreshName() {
    }

    protected IFigure createFigureForModel() {
        StickyNoteCommentFigure mainFigure = new StickyNoteCommentFigure();
        mainFigure.setCommentText(this.getModel().getComment());
        return mainFigure;
    }

    public StickyNoteCommentFigure getFigure() {
        return (StickyNoteCommentFigure)super.getFigure();
    }

    protected void performDirectEdit() {
        new TextDirectEditManager((GraphicalEditPart)this, (CellEditorLocator)new FigureCellEditorLocator((IFigure)this.getFigure())){

            protected CellEditor createCellEditorOn(Composite composite) {
                return new TextCellEditor(composite, 66);
            }

            protected void initCellEditor() {
                super.initCellEditor();
                this.getCellEditor().setValue((Object)CommentEditPart.this.getModel().getComment());
            }
        }.show();
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new ComponentEditPolicy(){

            protected Command createDeleteCommand(GroupRequest request) {
                return new DeleteFBNetworkElementCommand((FBNetworkElement)((Comment)this.getHost().getModel()));
            }
        });
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new CommentRenameEditPolicy());
    }

    protected void refreshPosition() {
        if (this.getParent() != null) {
            Position position = this.getModel().getPosition();
            Rectangle bounds = new Rectangle(position.toScreenPoint(), this.getCommentSize());
            ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, (IFigure)this.getFigure(), (Object)bounds);
        }
    }

    protected void refreshComment() {
        this.getFigure().setCommentText(this.getModel().getComment());
    }

    public <T> T getAdapter(Class<T> key) {
        if (key == Comment.class) {
            return key.cast(this.getModel());
        }
        return (T)super.getAdapter(key);
    }

    private Dimension getCommentSize() {
        return new Dimension(CoordinateConverter.INSTANCE.iec61499ToScreen(this.getModel().getWidth()), CoordinateConverter.INSTANCE.iec61499ToScreen(this.getModel().getHeight()));
    }

    protected Adapter createContentAdapter() {
        return new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                super.notifyChanged(notification);
                Object feature = notification.getFeature();
                if (LibraryElementPackage.eINSTANCE.getComment_Width().equals(feature) || LibraryElementPackage.eINSTANCE.getComment_Height().equals(feature)) {
                    CommentEditPart.this.refreshPosition();
                }
            }
        };
    }

    private class CommentRenameEditPolicy
    extends AbstractViewRenameEditPolicy {
        private CommentRenameEditPolicy() {
        }

        protected Command getDirectEditCommand(DirectEditRequest request) {
            GraphicalEditPart graphicalEditPart = this.getHost();
            if (graphicalEditPart instanceof CommentEditPart) {
                CommentEditPart ep = (CommentEditPart)graphicalEditPart;
                String str = (String)request.getCellEditor().getValue();
                if (!InstanceCommentFigure.EMPTY_COMMENT.equals(str)) {
                    return new ChangeCommentCommand((INamedElement)ep.getModel(), str);
                }
            }
            return null;
        }

        protected void showCurrentEditValue(DirectEditRequest request) {
            String value = (String)request.getCellEditor().getValue();
            CommentEditPart.this.getFigure().setCommentText(value);
        }

        protected void revertOldEditValue(DirectEditRequest request) {
            CommentEditPart.this.refreshComment();
        }
    }

    public static class DogEar
    extends AbstractBorder {
        private static final Insets INSETS = new Insets(2, 3, 1, 3);

        public Insets getInsets(IFigure figure) {
            return INSETS;
        }

        public void paint(IFigure figure, Graphics g, Insets insets) {
            Rectangle r = DogEar.getPaintRectangle((IFigure)figure, (Insets)insets);
            r.resize(-1, -1);
            int[] nArray = new int[6];
            nArray[0] = -9;
            nArray[1] = 9;
            nArray[3] = 9;
            nArray[4] = -9;
            PointList pl = new PointList(nArray);
            pl.translate(r.getTopRight());
            g.drawPolygon(pl);
            g.drawLine(r.getTopLeft(), r.getTopRight().translate(-9, 0));
            g.drawLine(r.getTopLeft(), r.getTopLeft());
            g.drawLine(r.getBottomLeft(), r.getBottomRight());
            g.drawLine(r.getTopRight().translate(0, 9), r.getBottomRight());
            g.drawLine(r.getTopLeft(), r.getBottomLeft());
        }
    }

    public static final class StickyNoteCommentFigure
    extends Figure {
        private static final Color STICKY_NOTE_YELLOW = new Color(255, 255, 210);
        private final TextFlow textFlow;

        public StickyNoteCommentFigure() {
            this.setupFigure();
            this.setupRootLayout();
            this.textFlow = new TextFlow();
            this.textFlow.setLayoutManager((LayoutManager)new ParagraphTextLayout(this.textFlow, 1));
            FlowPage flowPage = new FlowPage();
            flowPage.setCursor(Cursors.SIZEALL);
            flowPage.add((IFigure)this.textFlow);
            this.add((IFigure)flowPage, new GridData(1808));
        }

        private void setupFigure() {
            this.setBorder((Border)new DogEar());
            this.setOpaque(true);
        }

        private void setupRootLayout() {
            GridLayout mainLayout = new GridLayout(1, true);
            mainLayout.marginHeight = 0;
            mainLayout.verticalSpacing = 0;
            mainLayout.horizontalSpacing = 0;
            this.setLayoutManager((LayoutManager)mainLayout);
        }

        public void setCommentText(String newCommentTest) {
            this.textFlow.setText(newCommentTest);
        }

        public void paintFigure(Graphics g) {
            if (this.getLocalBackgroundColor() != STICKY_NOTE_YELLOW) {
                this.setBackgroundColor(STICKY_NOTE_YELLOW);
            }
            Rectangle r = this.getBounds();
            PointList pl = new PointList(5);
            pl.addPoint(r.getTopLeft());
            pl.addPoint(r.getTopRight().translate(-9, 0));
            pl.addPoint(r.getTopRight().translate(0, 9));
            pl.addPoint(r.getBottomRight());
            pl.addPoint(r.getBottomLeft());
            g.fillPolygon(pl);
        }
    }
}

