/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.iec61499;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.fordiac.ide.deployment.Activator;
import org.eclipse.fordiac.ide.deployment.DeploymentCoordinator;
import org.eclipse.fordiac.ide.deployment.exceptions.DeploymentException;
import org.eclipse.fordiac.ide.deployment.iec61499.DynamicTypeLoadDeploymentExecutor;
import org.eclipse.fordiac.ide.deployment.interactors.DeviceManagementInteractorFactory;
import org.eclipse.fordiac.ide.deployment.interactors.IDeviceManagementInteractor;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class GetResourcesHandler
extends AbstractHandler {
    private static List<Object> getDeviceList(ExecutionEvent event) {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof StructuredSelection) {
            return ((StructuredSelection)selection).toList();
        }
        return Collections.emptyList();
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        for (Object object : GetResourcesHandler.getDeviceList(event)) {
            Device device = null;
            if (object instanceof EditPart) {
                object = ((EditPart)object).getModel();
            }
            if (object instanceof Device) {
                device = (Device)object;
            }
            GetResourcesHandler.fetchResources(device);
        }
        return null;
    }

    private static void fetchResources(Device device) {
        IDeviceManagementInteractor interactor = DeviceManagementInteractorFactory.INSTANCE.getDeviceManagementInteractor(device);
        if (interactor instanceof DynamicTypeLoadDeploymentExecutor) {
            block12: {
                DeploymentCoordinator.INSTANCE.enableOutput(interactor);
                try {
                    try {
                        interactor.connect();
                        ((DynamicTypeLoadDeploymentExecutor)interactor).queryResourcesWithNetwork(device);
                    }
                    catch (Exception e) {
                        Activator.getDefault().logError(e.getMessage(), e);
                        try {
                            interactor.disconnect();
                        }
                        catch (DeploymentException e2) {
                            Activator.getDefault().logError(e2.getMessage(), (Exception)((Object)e2));
                        }
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        interactor.disconnect();
                    }
                    catch (DeploymentException e) {
                        Activator.getDefault().logError(e.getMessage(), (Exception)((Object)e));
                    }
                    throw throwable;
                }
                try {
                    interactor.disconnect();
                }
                catch (DeploymentException e) {
                    Activator.getDefault().logError(e.getMessage(), (Exception)((Object)e));
                }
            }
            DeploymentCoordinator.INSTANCE.disableOutput(interactor);
        }
    }
}

