/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.common.util.objects;

import choco.kernel.common.util.iterators.DisposableIntIterator;
import java.util.Arrays;

public class DoubleLinkedList
extends DisposableIntIterator {
    protected final int[] nextT;
    protected final int[] prevT;
    protected int size;
    protected int currentT;
    protected final int listSize;

    public DoubleLinkedList(int listSize) {
        this.listSize = listSize;
        this.nextT = new int[listSize + 1];
        this.prevT = new int[listSize + 1];
        this.reset();
    }

    public DoubleLinkedList(DoubleLinkedList origin) {
        this.nextT = new int[origin.nextT.length];
        this.prevT = new int[origin.prevT.length];
        System.arraycopy(origin.nextT, 0, this.nextT, 0, this.nextT.length);
        System.arraycopy(origin.prevT, 0, this.prevT, 0, this.prevT.length);
        this.size = origin.size;
        this.listSize = origin.listSize;
    }

    public void addVal(int val) {
        if (this.size == 0) {
            this.nextT[this.listSize] = val;
            this.prevT[this.listSize] = val;
        } else {
            this.prevT[this.nextT[this.listSize]] = val;
            this.nextT[val] = this.nextT[this.listSize];
            this.nextT[this.listSize] = val;
        }
        ++this.size;
    }

    public void removeVal(int val) {
        if (this.size == 1) {
            this.nextT[this.listSize] = -1;
            this.prevT[this.listSize] = -1;
        } else if (this.nextT[this.listSize] == val) {
            this.nextT[this.listSize] = this.nextT[val];
            this.prevT[this.nextT[val]] = -1;
        } else if (this.prevT[this.listSize] == val) {
            this.prevT[this.listSize] = this.prevT[val];
            this.nextT[this.prevT[val]] = -1;
        } else {
            this.nextT[this.prevT[val]] = this.nextT[val];
            this.prevT[this.nextT[val]] = this.prevT[val];
        }
        this.nextT[val] = -1;
        this.prevT[val] = -1;
        --this.size;
    }

    public final boolean contains(int val) {
        return this.isIn(val);
    }

    public final int getSize() {
        return this.size;
    }

    public void reset() {
        this.size = 0;
        Arrays.fill(this.nextT, -1);
        Arrays.fill(this.prevT, -1);
        this.restart();
    }

    public final void restart() {
        this.currentT = this.listSize;
    }

    public final void restartFrom(int val) {
        this.currentT = val;
    }

    @Override
    public boolean hasNext() {
        return this.currentT != -1 && this.nextT[this.currentT] != -1;
    }

    public boolean hasNextTo(int val) {
        return this.currentT != -1 && this.nextT[this.currentT] != val;
    }

    @Override
    public int next() {
        this.currentT = this.nextT[this.currentT];
        return this.currentT;
    }

    public int read() {
        return this.currentT;
    }

    public final int getFirst() {
        return this.nextT[this.listSize];
    }

    public final int getLast() {
        return this.prevT[this.listSize];
    }

    public final boolean isIn(int val) {
        return this.nextT[this.listSize] == val || this.prevT[val] != -1;
    }

    public final void restrict(int val) {
        this.reset();
        this.addVal(val);
    }

    public final int[] toArray() {
        int[] tab = new int[this.size];
        int cpt = 0;
        this.restart();
        while (this.hasNext()) {
            tab[cpt] = this.next();
            ++cpt;
        }
        return tab;
    }

    @Override
    public void remove() {
        int pred = this.currentT != this.nextT[this.listSize] ? this.prevT[this.currentT] : this.listSize;
        this.removeVal(this.currentT);
        this.currentT = pred;
    }

    public String toString() {
        StringBuilder n = new StringBuilder("next    :");
        StringBuilder p = new StringBuilder("suivant :");
        for (int i = 0; i < this.nextT.length; ++i) {
            n.append(this.nextT[i]).append(' ');
            p.append(this.prevT[i]).append(' ');
        }
        return "first :" + this.nextT[this.listSize] + "| " + "last :" + this.prevT[this.listSize] + "| " + n + "| " + p;
    }

    @Override
    public void dispose() {
    }
}

