/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.real.exp;

import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.real.RealExp;
import choco.kernel.solver.constraints.real.exp.AbstractRealUnTerm;
import choco.kernel.solver.variables.real.RealInterval;
import choco.kernel.solver.variables.real.RealMath;

public final class RealSin
extends AbstractRealUnTerm {
    public RealSin(Solver solver, RealExp exp1) {
        super(solver, exp1);
    }

    @Override
    public String pretty() {
        return "sin(" + this.exp1.pretty() + ")";
    }

    @Override
    public void tighten() {
        RealInterval res = RealMath.sin(this.exp1);
        this.inf.set(res.getInf());
        this.sup.set(res.getSup());
    }

    @Override
    public void project() throws ContradictionException {
        RealInterval res = RealMath.asin_wrt(this, this.exp1);
        if (res.getInf() > res.getSup()) {
            this.solver.getPropagationEngine().raiseContradiction(this);
        }
        this.exp1.intersect(res);
    }
}

