/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima;

import ec.tstoolkit.arima.estimation.Forecasts;

public class LogForecasts {
    private boolean logc_ = false;
    private final Forecasts fcasts_;

    public LogForecasts(Forecasts f) {
        this.fcasts_ = f;
    }

    public boolean isLogCorrectionEnabled() {
        return this.logc_;
    }

    public void enableLogCorrection(boolean enable) {
        this.logc_ = enable;
    }

    public double getForecast(int idx) {
        double f = this.fcasts_.forecast(idx);
        f = Math.exp(f);
        if (this.logc_) {
            double ser = this.fcasts_.forecastStdev(idx);
            f *= Math.exp(ser * ser / 2.0);
        }
        return f;
    }

    public double[] getForecasts() {
        double[] f = (double[])this.fcasts_.getForecasts().clone();
        for (int i = 0; i < f.length; ++i) {
            f[i] = Math.exp(f[i]);
        }
        if (this.logc_) {
            double[] ef = this.fcasts_.getForecastStdevs();
            for (int i = 0; i < f.length; ++i) {
                int n = i;
                f[n] = f[n] * Math.exp(ef[i] * ef[i] / 2.0);
            }
        }
        return f;
    }

    public double getForecastStdev(int idx) {
        double ser = this.fcasts_.forecastStdev(idx);
        double m = this.fcasts_.forecast(idx);
        return LogForecasts.expStdev(ser, m);
    }

    public double[] getForecastStdevs() {
        double[] ef = (double[])this.fcasts_.getForecastStdevs().clone();
        double[] m = this.fcasts_.getForecasts();
        for (int i = 0; i < ef.length; ++i) {
            ef[i] = LogForecasts.expStdev(ef[i], m[i]);
        }
        return ef;
    }

    public static double expStdev(double ser, double m) {
        if (ser == 0.0) {
            return 0.0;
        }
        double lser = m + 0.5 * ser * ser;
        return Math.exp(lser) * Math.sqrt(Math.exp(ser * ser) - 1.0);
    }

    public static double expStdev2(double ser, double em) {
        if (ser == 0.0) {
            return 0.0;
        }
        double lser = 0.5 * ser * ser;
        return em * Math.exp(lser) * Math.sqrt(Math.exp(ser * ser) - 1.0);
    }

    public static double expMean(double ser, double m, boolean lcorr) {
        m = Math.exp(m);
        if (lcorr) {
            m *= Math.exp(ser * ser / 2.0);
        }
        return m;
    }
}

