/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR.util;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.JEditorPane;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import javax.swing.text.View;
import javax.swing.text.html.HTMLDocument;

public class DocumentRenderer
implements Printable {
    protected int currentPage = -1;
    protected JEditorPane jeditorPane;
    protected double pageEndY = 0.0;
    protected double pageStartY = 0.0;
    protected boolean scaleWidthToFit = true;
    protected PageFormat pFormat = new PageFormat();
    protected PrinterJob pJob = PrinterJob.getPrinterJob();

    public Document getDocument() {
        if (this.jeditorPane != null) {
            return this.jeditorPane.getDocument();
        }
        return null;
    }

    public void setDocument(JEditorPane jedPane) {
        this.jeditorPane = new JEditorPane();
        this.setDocument(jedPane.getContentType(), jedPane.getDocument());
    }

    public void setDocument(PlainDocument plainDocument) {
        this.jeditorPane = new JEditorPane();
        this.setDocument("text/rtf", plainDocument);
    }

    public boolean getScaleWidthToFit() {
        return this.scaleWidthToFit;
    }

    public void setScaleWidthToFit(boolean scaleWidth) {
        this.scaleWidthToFit = scaleWidth;
    }

    public void pageDialog() {
        this.pFormat = this.pJob.pageDialog(this.pFormat);
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) {
        double scale = 1.0;
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.jeditorPane.setSize((int)pageFormat.getImageableWidth(), Integer.MAX_VALUE);
        this.jeditorPane.validate();
        View rootView = this.jeditorPane.getUI().getRootView(this.jeditorPane);
        if (this.scaleWidthToFit && this.jeditorPane.getMinimumSize().getWidth() > pageFormat.getImageableWidth()) {
            scale = pageFormat.getImageableWidth() / this.jeditorPane.getMinimumSize().getWidth();
            graphics2D.scale(scale, scale);
        }
        graphics2D.setClip((int)(pageFormat.getImageableX() / scale), (int)(pageFormat.getImageableY() / scale), (int)(pageFormat.getImageableWidth() / scale), (int)(pageFormat.getImageableHeight() / scale));
        if (pageIndex > this.currentPage) {
            this.currentPage = pageIndex;
            this.pageStartY += this.pageEndY;
            this.pageEndY = graphics2D.getClipBounds().getHeight();
        }
        graphics2D.translate(graphics2D.getClipBounds().getX(), graphics2D.getClipBounds().getY());
        Rectangle allocation = new Rectangle(0, (int)(-this.pageStartY), (int)this.jeditorPane.getMinimumSize().getWidth(), (int)this.jeditorPane.getPreferredSize().getHeight());
        if (this.printView(graphics2D, allocation, rootView)) {
            return 0;
        }
        this.pageStartY = 0.0;
        this.pageEndY = 0.0;
        this.currentPage = -1;
        return 1;
    }

    public void print(HTMLDocument htmlDocument) {
        this.setDocument(htmlDocument);
        this.printDialog();
    }

    public void print(JEditorPane jedPane) {
        this.setDocument(jedPane);
        this.printDialog();
    }

    public void print(PlainDocument plainDocument) {
        this.setDocument(plainDocument);
        this.printDialog();
    }

    protected void printDialog() {
        if (this.pJob.printDialog()) {
            this.pJob.setPrintable(this, this.pFormat);
            try {
                this.pJob.print();
            }
            catch (PrinterException printerException) {
                this.pageStartY = 0.0;
                this.pageEndY = 0.0;
                this.currentPage = -1;
            }
        }
    }

    protected boolean printView(Graphics2D graphics2D, Shape allocation, View view) {
        boolean pageExists = false;
        Rectangle clipRectangle = graphics2D.getClipBounds();
        if (view.getViewCount() > 0) {
            for (int i = 0; i < view.getViewCount(); ++i) {
                View childView;
                Shape childAllocation = view.getChildAllocation(i, allocation);
                if (childAllocation == null || !this.printView(graphics2D, childAllocation, childView = view.getView(i))) continue;
                pageExists = true;
            }
        } else if (allocation.getBounds().getMaxY() >= clipRectangle.getY()) {
            pageExists = true;
            if (allocation.getBounds().getHeight() > clipRectangle.getHeight() && allocation.intersects(clipRectangle)) {
                view.paint(graphics2D, allocation);
            } else if (allocation.getBounds().getY() >= clipRectangle.getY()) {
                if (allocation.getBounds().getMaxY() <= clipRectangle.getMaxY()) {
                    view.paint(graphics2D, allocation);
                } else if (allocation.getBounds().getY() < this.pageEndY) {
                    this.pageEndY = allocation.getBounds().getY();
                }
            }
        }
        return pageExists;
    }

    protected void setContentType(String type) {
        this.jeditorPane.setContentType(type);
    }

    public void setDocument(HTMLDocument htmlDocument) {
        this.jeditorPane = new JEditorPane();
        this.setDocument("text/html", htmlDocument);
    }

    protected void setDocument(String type, Document document) {
        this.setContentType(type);
        this.jeditorPane.setDocument(document);
    }
}

