/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.Likelihood;
import dr.inference.model.Parameter;
import dr.math.NumericalDerivative;
import dr.math.UnivariateFunction;
import dr.math.distributions.RandomGenerator;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.Reportable;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.ArrayList;
import java.util.List;

public class LikelihoodProfile
implements Reportable {
    public static final String SEP = ",";
    public static final String ENDL = "\n";
    public static final String LIKELIHOOD_PROFILE = "likelihoodProfile";
    private RandomGenerator generator;
    private int mcSamples = 1;
    private Parameter integrated;
    private int count = 0;
    private final Likelihood likelihood;
    private final Parameter parameter;
    private final UnivariateFunction function;
    private int dim;
    private double lowerBound;
    private double upperBound;
    private int numPoints;
    private List<ProfilePoint> profilePoints = new ArrayList<ProfilePoint>();
    public static final String DIM = "dim";
    public static final String LOWER_BOUND = "lower";
    public static final String UPPER_BOUND = "upper";
    public static final String GRID_POINTS = "points";
    public static final String EXPECTATION = "expectation";
    public static final String MC_SAMPLES = "samples";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newDoubleArrayRule("lower"), AttributeRule.newDoubleArrayRule("upper"), AttributeRule.newIntegerRule("dim", true), AttributeRule.newIntegerRule("points", true), new ElementRule(Likelihood.class), new ElementRule(Parameter.class), new ElementRule("expectation", new XMLSyntaxRule[]{AttributeRule.newIntegerRule("samples"), new ElementRule(RandomGenerator.class), new ElementRule(Parameter.class)}, true)};

        @Override
        public String getParserName() {
            return LikelihoodProfile.LIKELIHOOD_PROFILE;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            Likelihood likelihood = (Likelihood)xMLObject.getChild(Likelihood.class);
            Parameter parameter = (Parameter)xMLObject.getChild(Parameter.class);
            int n = xMLObject.getAttribute(LikelihoodProfile.DIM, 0);
            double d = xMLObject.getDoubleAttribute(LikelihoodProfile.LOWER_BOUND);
            double d2 = xMLObject.getDoubleAttribute(LikelihoodProfile.UPPER_BOUND);
            int n2 = xMLObject.getAttribute(LikelihoodProfile.GRID_POINTS, 100);
            LikelihoodProfile likelihoodProfile = new LikelihoodProfile(likelihood, parameter, n, d, d2, n2);
            if (xMLObject.hasChildNamed(LikelihoodProfile.EXPECTATION)) {
                XMLObject xMLObject2 = xMLObject.getChild(LikelihoodProfile.EXPECTATION);
                int n3 = xMLObject2.getAttribute(LikelihoodProfile.MC_SAMPLES, 1);
                RandomGenerator randomGenerator = (RandomGenerator)xMLObject2.getChild(RandomGenerator.class);
                Parameter parameter2 = (Parameter)xMLObject2.getChild(Parameter.class);
                likelihoodProfile.addGeneratorForExpectation(randomGenerator, parameter2, n3);
            }
            return likelihoodProfile;
        }

        @Override
        public String getParserDescription() {
            return "This element represents a tool to profile a likelihood surface";
        }

        @Override
        public Class getReturnType() {
            return LikelihoodProfile.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };

    public LikelihoodProfile(Likelihood likelihood, Parameter parameter, int n, double d, double d2, int n2) {
        this.likelihood = likelihood;
        this.parameter = parameter;
        this.dim = n;
        this.lowerBound = d;
        this.upperBound = d2;
        this.numPoints = n2;
        this.function = new UnivariateFunction(){

            @Override
            public double evaluate(double d) {
                LikelihoodProfile.this.parameter.setParameterValue(LikelihoodProfile.this.dim, d);
                return LikelihoodProfile.this.likelihood.getLogLikelihood();
            }

            @Override
            public double getLowerBound() {
                return LikelihoodProfile.this.lowerBound;
            }

            @Override
            public double getUpperBound() {
                return LikelihoodProfile.this.upperBound;
            }
        };
    }

    @Override
    public String getReport() {
        if (this.profilePoints.size() == 0) {
            this.generateProfile();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("x").append(SEP).append("f").append(SEP).append("df").append(SEP).append("ddf").append(ENDL);
        for (ProfilePoint profilePoint : this.profilePoints) {
            stringBuilder.append(profilePoint.toString());
        }
        return stringBuilder.toString();
    }

    private void generateProfile() {
        double d = (this.upperBound - this.lowerBound) / (double)(this.numPoints - 1);
        double d2 = this.lowerBound;
        for (int i = 0; i < this.numPoints; ++i) {
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            for (int j = 0; j < this.mcSamples; ++j) {
                if (this.generator != null) {
                    this.integrateGenerator(d2);
                }
                d3 += this.function.evaluate(d2);
                d4 += NumericalDerivative.firstDerivative(this.function, d2);
                d5 += NumericalDerivative.secondDerivative(this.function, d2);
            }
            this.profilePoints.add(new ProfilePoint(d2, d3 /= (double)this.mcSamples, d4 /= (double)this.mcSamples, d5 /= (double)this.mcSamples));
            d2 += d;
        }
    }

    private void integrateGenerator(double d) {
        this.parameter.setParameterValue(this.dim, d);
        double[] dArray = (double[])this.generator.nextRandom();
        int n = dArray.length;
        if (n != this.integrated.getDimension()) {
            throw new RuntimeException("Invalid integrated parameter and generator");
        }
        for (int i = 0; i < n; ++i) {
            dArray[i] = 0.0;
            this.integrated.setParameterValue(i, dArray[i]);
        }
    }

    private void addGeneratorForExpectation(RandomGenerator randomGenerator, Parameter parameter, int n) {
        this.generator = randomGenerator;
        this.integrated = parameter;
        this.mcSamples = n;
    }

    private class ProfilePoint {
        public double x;
        public double f;
        public double df;
        public double ddf;

        ProfilePoint(double d, double d2, double d3, double d4) {
            this.x = d;
            this.f = d2;
            this.df = d3;
            this.ddf = d4;
        }

        public String toString() {
            return this.x + LikelihoodProfile.SEP + this.f + LikelihoodProfile.SEP + this.df + LikelihoodProfile.SEP + this.ddf + LikelihoodProfile.ENDL;
        }
    }
}

