/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.distribution;

import dr.inference.distribution.ParametricDistributionModel;
import dr.inference.model.CompoundModel;
import dr.inference.model.Likelihood;
import dr.inference.model.Model;
import dr.inference.model.Statistic;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MixedDistributionLikelihood
extends Likelihood.Abstract {
    private final ParametricDistributionModel[] distributions;
    private final Statistic data;
    private final Statistic indicators;
    private boolean impliedOne = false;

    public MixedDistributionLikelihood(ParametricDistributionModel[] parametricDistributionModelArray, Statistic statistic, Statistic statistic2) {
        super(new CompoundModel("MixedDistributions"));
        CompoundModel compoundModel = (CompoundModel)this.getModel();
        for (ParametricDistributionModel parametricDistributionModel : parametricDistributionModelArray) {
            compoundModel.addModel(parametricDistributionModel);
        }
        this.distributions = parametricDistributionModelArray;
        this.data = statistic;
        this.indicators = statistic2;
        if (statistic2.getDimension() == statistic.getDimension() - 1) {
            this.impliedOne = true;
        } else if (statistic2.getDimension() != statistic.getDimension()) {
            throw new IllegalArgumentException("Indicators length (" + statistic2.getDimension() + ") != data length (" + statistic.getDimension() + ")");
        }
    }

    @Override
    public final double calculateLogLikelihood() {
        double d = 0.0;
        for (int i = 0; i < this.data.getDimension(); ++i) {
            int n = this.impliedOne ? (i == 0 ? 1 : (int)this.indicators.getStatisticValue(i - 1)) : (int)this.indicators.getStatisticValue(i);
            d += this.distributions[n].logPdf(this.data.getStatisticValue(i));
        }
        return d;
    }

    @Override
    protected boolean getLikelihoodKnown() {
        return false;
    }

    public Element createElement(Document document) {
        throw new RuntimeException("Not implemented yet!");
    }

    public Model[] getUniqueModels() {
        Model[] modelArray = new Model[this.distributions[0] == this.distributions[1] ? 1 : 2];
        modelArray[0] = this.distributions[0];
        if (modelArray.length > 1) {
            modelArray[1] = this.distributions[1];
        }
        return modelArray;
    }
}

