/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.util;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.vikamine.kernel.data.Attribute;
import org.vikamine.kernel.data.IDataRecordSet;
import org.vikamine.kernel.data.NominalAttribute;
import org.vikamine.kernel.data.NumericAttribute;

public class VKMUtil {
    public static final double SMALL = 1.0E-6;
    private static String lineSeparatorSaver = null;
    public static final String LINE_SEPARATOR_PROPERTY = "line.separator";

    public static void setNewLineAsLinefeedLineSeparator() {
        if (lineSeparatorSaver == null) {
            lineSeparatorSaver = System.getProperty(LINE_SEPARATOR_PROPERTY);
        }
        System.setProperty(LINE_SEPARATOR_PROPERTY, "\n");
    }

    public static void restoreSavedLineSeparator() {
        System.setProperty(LINE_SEPARATOR_PROPERTY, lineSeparatorSaver);
        lineSeparatorSaver = null;
    }

    public static String getFormattedDoubleStringDependingOnLocale(Locale theLocale, double theDouble) {
        return VKMUtil.getFormattedDoubleStringDependingOnLocale(theLocale, theDouble, 3);
    }

    public static String getFormattedDoubleStringDependingOnLocale(Locale theLocale, double theDouble, int fractionDigits) {
        if (Double.isNaN(theDouble)) {
            return "-";
        }
        if (Double.isInfinite(theDouble)) {
            return theDouble > 0.0 ? "Inf" : "- Inf";
        }
        BigDecimal scaledBigDecimal = new BigDecimal(theDouble);
        scaledBigDecimal = scaledBigDecimal.setScale(fractionDigits + 1, 4);
        scaledBigDecimal = scaledBigDecimal.setScale(fractionDigits, 4);
        double scaledDouble = scaledBigDecimal.doubleValue();
        NumberFormat formater = NumberFormat.getNumberInstance(theLocale);
        formater.setMinimumFractionDigits(fractionDigits);
        formater.setMaximumFractionDigits(fractionDigits);
        String result = formater.format(scaledDouble);
        return result;
    }

    public static String getFormattedDoubleString(double theDouble) {
        return VKMUtil.getFormattedDoubleStringDependingOnLocale(Locale.getDefault(), theDouble);
    }

    public static String getFormattedDoubleString(double theDouble, int fractionDigits) {
        return VKMUtil.getFormattedDoubleStringDependingOnLocale(Locale.getDefault(), theDouble, fractionDigits);
    }

    public static String formatDoubleToMinDigitsOrExponentialString(double d, int fractionDigits) {
        if (d > Math.pow(0.1, fractionDigits)) {
            return VKMUtil.getFormattedDoubleString(d, fractionDigits);
        }
        NumberFormat format = NumberFormat.getNumberInstance(Locale.getDefault());
        if (format instanceof DecimalFormat) {
            DecimalFormat decFormat = (DecimalFormat)format;
            decFormat.applyPattern("0.0E0");
            return decFormat.format(d);
        }
        return VKMUtil.getFormattedDoubleString(d, fractionDigits);
    }

    public static List computePowerSet(List initialList) {
        LinkedList<List> result = new LinkedList<List>();
        if (initialList.isEmpty()) {
            result.add(Collections.EMPTY_LIST);
            return result;
        }
        Object currentElement = initialList.get(0);
        LinkedList tmp = new LinkedList(initialList);
        tmp.remove(currentElement);
        List powerSet = VKMUtil.computePowerSet(tmp);
        for (List currentSet : powerSet) {
            result.add(currentSet);
            LinkedList currentSetPlusCurrentElement = new LinkedList(currentSet);
            currentSetPlusCurrentElement.add(currentElement);
            result.add(currentSetPlusCurrentElement);
        }
        return result;
    }

    public static <T> List<T> asList(Iterator<T> iterator) {
        ArrayList<T> result = new ArrayList<T>();
        while (iterator.hasNext()) {
            result.add(iterator.next());
        }
        return result;
    }

    public static double getDoubleWithMaxFractionDigits(double d, int digits) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            return d;
        }
        double div = (int)Math.pow(10.0, digits);
        double newVal = (double)Math.round(d * div) / div;
        return newVal;
    }

    public static boolean stringStartsWithIgnoreCase(String s, String q) {
        if (s.length() < q.length()) {
            return false;
        }
        return s.substring(0, q.length()).equalsIgnoreCase(q);
    }

    public static String doubleToString(double value, int afterDecimalPoint) {
        double temp = value * Math.pow(10.0, afterDecimalPoint);
        if (Math.abs(temp) < 9.223372036854776E18) {
            long precisionValue = temp > 0.0 ? (long)(temp + 0.5) : -((long)(Math.abs(temp) + 0.5));
            StringBuffer stringBuffer = precisionValue == 0L ? new StringBuffer(String.valueOf(0)) : new StringBuffer(String.valueOf(precisionValue));
            if (afterDecimalPoint == 0) {
                return stringBuffer.toString();
            }
            int dotPosition = stringBuffer.length() - afterDecimalPoint;
            while (precisionValue < 0L && dotPosition < 1 || dotPosition < 0) {
                if (precisionValue < 0L) {
                    stringBuffer.insert(1, '0');
                } else {
                    stringBuffer.insert(0, '0');
                }
                ++dotPosition;
            }
            stringBuffer.insert(dotPosition, '.');
            if (precisionValue < 0L && stringBuffer.charAt(1) == '.') {
                stringBuffer.insert(1, '0');
            } else if (stringBuffer.charAt(0) == '.') {
                stringBuffer.insert(0, '0');
            }
            int currentPos = stringBuffer.length() - 1;
            while (currentPos > dotPosition && stringBuffer.charAt(currentPos) == '0') {
                stringBuffer.setCharAt(currentPos--, ' ');
            }
            if (stringBuffer.charAt(currentPos) == '.') {
                stringBuffer.setCharAt(currentPos, ' ');
            }
            return stringBuffer.toString().trim();
        }
        return "" + value;
    }

    public static boolean eq(double a, double b) {
        return a - b < 1.0E-6 && b - a < 1.0E-6;
    }

    public static String quote(String string) {
        boolean quote = false;
        if (string.indexOf(10) != -1 || string.indexOf(13) != -1 || string.indexOf(39) != -1 || string.indexOf(34) != -1 || string.indexOf(92) != -1 || string.indexOf(9) != -1 || string.indexOf(37) != -1) {
            string = VKMUtil.backQuoteChars(string);
            quote = true;
        }
        if (quote || string.indexOf(123) != -1 || string.indexOf(125) != -1 || string.indexOf(44) != -1 || string.equals("?") || string.indexOf(32) != -1 || string.equals("")) {
            string = "'".concat(string).concat("'");
        }
        return string;
    }

    public static String backQuoteChars(String string) {
        char[] charsFind = new char[]{'\\', '\'', '\t', '\"', '%'};
        String[] charsReplace = new String[]{"\\\\", "\\'", "\\t", "\\\"", "\\%"};
        int i = 0;
        while (i < charsFind.length) {
            if (string.indexOf(charsFind[i]) != -1) {
                int index;
                StringBuffer newStringBuffer = new StringBuffer();
                while ((index = string.indexOf(charsFind[i])) != -1) {
                    if (index > 0) {
                        newStringBuffer.append(string.substring(0, index));
                    }
                    newStringBuffer.append(charsReplace[i]);
                    string = index + 1 < string.length() ? string.substring(index + 1) : "";
                }
                newStringBuffer.append(string);
                string = newStringBuffer.toString();
            }
            ++i;
        }
        return VKMUtil.convertNewLines(string);
    }

    public static String convertNewLines(String string) {
        int index;
        StringBuffer newStringBuffer = new StringBuffer();
        while ((index = string.indexOf(10)) != -1) {
            if (index > 0) {
                newStringBuffer.append(string.substring(0, index));
            }
            newStringBuffer.append('\\');
            newStringBuffer.append('n');
            string = index + 1 < string.length() ? string.substring(index + 1) : "";
        }
        newStringBuffer.append(string);
        string = newStringBuffer.toString();
        newStringBuffer = new StringBuffer();
        while ((index = string.indexOf(13)) != -1) {
            if (index > 0) {
                newStringBuffer.append(string.substring(0, index));
            }
            newStringBuffer.append('\\');
            newStringBuffer.append('r');
            string = index + 1 < string.length() ? string.substring(index + 1) : "";
        }
        newStringBuffer.append(string);
        return newStringBuffer.toString();
    }

    public static <T> List<T> filterListOnSubclass(Iterable<? super T> aList, Class<T> filterClass) {
        ArrayList<T> result = new ArrayList<T>();
        for (T o : aList) {
            if (!filterClass.isInstance(o)) continue;
            result.add(o);
        }
        return result;
    }

    public static long getCpuTime() {
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        return bean.isCurrentThreadCpuTimeSupported() ? bean.getCurrentThreadCpuTime() : 0L;
    }

    public static int getValueCount(Attribute att, IDataRecordSet dataset) {
        if (att.isNumeric()) {
            return ((NumericAttribute)att).getUsedValuesCount(dataset);
        }
        if (att.isNominal()) {
            return ((NominalAttribute)att).getValuesCount();
        }
        return -1;
    }
}

