/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.util;

import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import org.vikamine.kernel.data.Attribute;
import org.vikamine.kernel.data.DataRecord;

public class DateStatistics {
    public static final int AGGREGATION_LEVEL_ALL = -1;
    public static final int AGGREGATION_LEVEL_QUARTER = -2;
    private Attribute dateDMAttribute;
    private int aggregationLevel;
    private Iterator<DataRecord> instances;
    private List intervals;
    private Date endDate;
    private Date startDate;

    public DateStatistics(Attribute att, int aggregationLevel, Date startDate, Date endDate, Iterator<DataRecord> instances) {
        if (!att.isDate()) {
            throw new IllegalArgumentException("must be a date-attribute");
        }
        this.dateDMAttribute = att;
        this.aggregationLevel = aggregationLevel;
        this.instances = instances;
        this.startDate = startDate;
        this.endDate = endDate;
        this.intervals = this.buildIntervals();
    }

    public DateStatistics(Attribute att, Date startDate, Date endDate, Iterator<DataRecord> instances) {
        this(att, -1, startDate, endDate, instances);
    }

    private int getReducedAggregationLevel(int aggregationLevel) {
        if (aggregationLevel == -1 || aggregationLevel == -2) {
            return 14;
        }
        switch (aggregationLevel) {
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                return 14;
            }
        }
        Logger.getLogger(this.getClass().getName()).throwing(this.getClass().getName(), "getReducedAggregationLevel", new IllegalArgumentException("Unknown Aggregationlevel " + aggregationLevel));
        throw new IllegalArgumentException("Unknown Aggregationlevel " + aggregationLevel);
    }

    private List buildEmptySortedIntervals() {
        LinkedList<Interval> sortedIntervalList = new LinkedList<Interval>();
        if (this.aggregationLevel != -1) {
            GregorianCalendar currentCal = new GregorianCalendar();
            currentCal.setTime(this.startDate);
            GregorianCalendar endCal = new GregorianCalendar();
            endCal.setTime(this.endDate);
            while (!currentCal.after(endCal)) {
                Interval interval = new Interval();
                interval.begin = (GregorianCalendar)currentCal.clone();
                if (this.aggregationLevel == -2) {
                    currentCal.add(2, 3);
                } else {
                    currentCal.add(this.aggregationLevel, 1);
                }
                if (!currentCal.after(endCal)) {
                    interval.end = (GregorianCalendar)currentCal.clone();
                    int reducedAggregationLevel = this.getReducedAggregationLevel(this.aggregationLevel);
                    interval.end.add(reducedAggregationLevel, -1);
                } else {
                    interval.end = (GregorianCalendar)endCal.clone();
                }
                sortedIntervalList.add(interval);
            }
        } else if (this.aggregationLevel == -1) {
            GregorianCalendar currentCal = new GregorianCalendar();
            currentCal.setTime(this.startDate);
            GregorianCalendar endCal = new GregorianCalendar();
            endCal.setTime(this.endDate);
            Interval interval = new Interval();
            interval.begin = currentCal;
            interval.end = endCal;
            sortedIntervalList.add(interval);
        } else {
            Logger.getLogger(this.getClass().getName()).throwing(this.getClass().getName(), "buildEmptySortedIntervals", new IllegalStateException("Unknown aggregationlevel " + this.aggregationLevel));
        }
        return sortedIntervalList;
    }

    private List buildIntervals() {
        double[] values = this.buildValues();
        List sortedIntervalList = this.buildEmptySortedIntervals();
        int i = 0;
        while (i < values.length) {
            long time = (long)values[i];
            if (this.isValid(time)) {
                Interval interval = this.getMatchingInterval(sortedIntervalList, time);
                ++interval.instancesCount;
            }
            ++i;
        }
        return sortedIntervalList;
    }

    private Interval getMatchingInterval(List sortedIntervalList, long time) {
        for (Interval interval : sortedIntervalList) {
            if (interval.begin.getTimeInMillis() > time || interval.end.getTimeInMillis() < time) continue;
            return interval;
        }
        throw new IllegalArgumentException("Time " + time + " not found in interval list!");
    }

    private boolean isValid(long time) {
        if (this.startDate != null && time < this.startDate.getTime()) {
            return false;
        }
        return this.endDate == null || time <= this.endDate.getTime();
    }

    private double[] buildValues() {
        LinkedList<Double> values = new LinkedList<Double>();
        while (this.instances.hasNext()) {
            DataRecord inst = this.instances.next();
            double val = inst.getValue(this.dateDMAttribute);
            if (Double.isNaN(val)) continue;
            values.add(new Double(val));
        }
        double[] array = new double[values.size()];
        int i = 0;
        for (Double d : values) {
            array[i] = d;
            ++i;
        }
        Arrays.sort(array);
        return array;
    }

    public List getIntervals() {
        return this.intervals;
    }

    public static class Interval {
        public GregorianCalendar begin;
        public GregorianCalendar end;
        public int instancesCount = 0;
    }
}

