/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.vikamine.kernel.subgroup.selectors.NegatedSGSelector;
import org.vikamine.kernel.subgroup.selectors.NumericSelector;
import org.vikamine.kernel.subgroup.selectors.SGSelector;

public class FPNodeNumeric {
    public final SGSelector sel;
    public double sum = 0.0;
    public double estimate = 0.0;
    public double n = 0.0;
    public List<FPTreeNodeNumeric> siblings = new ArrayList<FPTreeNodeNumeric>();

    public FPNodeNumeric(SGSelector sel) {
        this.sel = sel;
    }

    public String toString() {
        return this.sel + "(sum:" + this.sum + ", n:" + this.n + ", estimate:" + this.estimate + ")";
    }

    public List<? extends FPTreePathNumeric> getAllPrefixPaths() {
        ArrayList<FPTreePathNumeric> paths = new ArrayList<FPTreePathNumeric>();
        boolean allowsForMultipleSelectorsPerAttribute = this.sel instanceof NegatedSGSelector || this.sel instanceof NumericSelector;
        for (FPTreeNodeNumeric activeNode : this.siblings) {
            FPTreePathNumeric path = new FPTreePathNumeric();
            FPTreeNodeNumeric parent = activeNode.parent;
            while (parent.sel != null) {
                if (allowsForMultipleSelectorsPerAttribute || parent.sel.getAttribute() != this.sel.getAttribute()) {
                    path.selectors.add(parent.sel);
                }
                parent = parent.parent;
            }
            if (path.selectors.isEmpty()) continue;
            path.sum = activeNode.sum;
            path.estimate = activeNode.estimate;
            path.n = activeNode.n;
            paths.add(path);
        }
        return paths;
    }

    static class FPTreeNodeNumeric
    extends FPNodeNumeric {
        public FPTreeNodeNumeric parent = null;
        public List<FPTreeNodeNumeric> children = new ArrayList<FPTreeNodeNumeric>();

        public FPTreeNodeNumeric(SGSelector sel) {
            super(sel);
        }

        public FPTreeNodeNumeric getChildForSelector(SGSelector sel) {
            for (FPTreeNodeNumeric aChild : this.children) {
                if (aChild.sel != sel) continue;
                return aChild;
            }
            return null;
        }
    }

    static class FPTreePathNumeric {
        public Set<SGSelector> selectors = new HashSet<SGSelector>();
        public double sum;
        public double estimate;
        public double n;

        public String toString() {
            return "(sum:" + this.sum + ", n:" + this.n + ", sum:" + this.sum + ")" + this.selectors;
        }

        public boolean containsAnySelectors(Collection<SGSelector> selectors) {
            for (SGSelector s : selectors) {
                if (!selectors.contains(s)) continue;
                return true;
            }
            return false;
        }
    }
}

