/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.vikamine.kernel.subgroup.selectors.NegatedSGSelector;
import org.vikamine.kernel.subgroup.selectors.NumericSelector;
import org.vikamine.kernel.subgroup.selectors.SGSelector;

public class FPNode {
    public SGSelector sel;
    public double tp = 0.0;
    public double n;
    public List<FPTreeNode> siblings = new ArrayList<FPTreeNode>();

    public FPNode(SGSelector sel) {
        this.sel = sel;
    }

    public double getFP() {
        return this.n - this.tp;
    }

    public String toString() {
        return this.sel + "(tp:" + this.tp + ", n:" + this.n + ", fp:" + this.getFP() + ")";
    }

    public List<? extends FPTreePath> getAllPrefixPaths() {
        ArrayList<FPTreePath> paths = new ArrayList<FPTreePath>();
        boolean allowsForMultipleSelectorsPerAttribute = this.sel instanceof NegatedSGSelector || this.sel instanceof NumericSelector;
        for (FPTreeNode activeNode : this.siblings) {
            FPTreePath path = new FPTreePath();
            FPTreeNode parent = activeNode.parent;
            while (parent.sel != null) {
                if (allowsForMultipleSelectorsPerAttribute || parent.sel.getAttribute() != this.sel.getAttribute()) {
                    path.selectors.add(parent.sel);
                }
                parent = parent.parent;
            }
            if (path.selectors.isEmpty()) continue;
            path.tp = activeNode.tp;
            path.n = activeNode.n;
            paths.add(path);
        }
        return paths;
    }

    static class FPTreeNode
    extends FPNode {
        public FPTreeNode parent = null;
        public List<FPTreeNode> children = new ArrayList<FPTreeNode>();

        public FPTreeNode(SGSelector sel) {
            super(sel);
        }

        public FPTreeNode getChildForSelector(SGSelector sel) {
            for (FPTreeNode aChild : this.children) {
                if (aChild.sel != sel) continue;
                return aChild;
            }
            return null;
        }
    }

    static class FPTreePath {
        public Set<SGSelector> selectors = new HashSet<SGSelector>();
        public double tp;
        public double n;

        public double getFP() {
            return this.n - this.tp;
        }

        public String toString() {
            return "(tp:" + this.tp + ", n:" + this.n + ", fp:" + this.getFP() + ")" + this.selectors;
        }

        public boolean containsAnySelectors(Collection<SGSelector> selectors) {
            for (SGSelector s : selectors) {
                if (!selectors.contains(s)) continue;
                return true;
            }
            return false;
        }
    }
}

