/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup.quality.functions;

import org.vikamine.kernel.subgroup.SG;
import org.vikamine.kernel.subgroup.SGStatistics;
import org.vikamine.kernel.subgroup.SGStatisticsNumeric;
import org.vikamine.kernel.subgroup.quality.AbstractQFStatisticBased;

public class InterclassVarianceQF
extends AbstractQFStatisticBased {
    private static final String ID = "Interclass variance QF";

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String getName() {
        return ID;
    }

    @Override
    public boolean isApplicable(SG subgroup) {
        return subgroup.getTarget().isNumeric();
    }

    @Override
    public double evaluate(SGStatistics statistics) {
        if (!(statistics instanceof SGStatisticsNumeric)) {
            return Double.NaN;
        }
        SGStatisticsNumeric numStats = (SGStatisticsNumeric)statistics;
        double nSG = numStats.getSubgroupSize();
        double sumSG = numStats.getSumOfTargetValuesSG();
        double mSG = numStats.getSGMean();
        if (nSG == 0.0) {
            return 0.0;
        }
        double nPop = numStats.getDefinedPopulationCount();
        double sumPop = numStats.getSumOfTargetValuesPopulation();
        double mPop = numStats.getPopulationMean();
        double nComplement = nPop - nSG;
        double sumComplement = sumPop - sumSG;
        if (nComplement == 0.0) {
            return 0.0;
        }
        double meanComplement = sumComplement / nComplement;
        return this.evaluate(nSG, mSG, mPop, nComplement, meanComplement);
    }

    public double evaluate(double nSG, double mSG, double mPop, double nComplement, double meanComplement) {
        return nSG * (mSG - mPop) * (mSG - mPop) + nComplement * (meanComplement - mPop) * (meanComplement - mPop);
    }

    @Override
    public AbstractQFStatisticBased clone() {
        return new InterclassVarianceQF();
    }
}

