/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.statistics;

public class ChiSquareStatistics {
    private static final double CHI2_MINFREQ_RELIABILITY_THRESHOLD = 5.0;

    private ChiSquareStatistics() {
    }

    public static double computeFourFoldChiSqare(double freqXAndY, double freqNotXAndY, double freqXAndNotY, double freqNotXAndNotY) {
        double freqX = freqXAndY + freqXAndNotY;
        double freqNotX = freqNotXAndY + freqNotXAndNotY;
        double freqY = freqXAndY + freqNotXAndY;
        double freqNotY = freqXAndNotY + freqNotXAndNotY;
        if (freqX >= 6.0 && freqNotX >= 6.0 && freqY >= 6.0 && freqNotY >= 6.0) {
            if (ChiSquareStatistics.checkForChi2Reliablity(freqXAndY, freqNotXAndY, freqXAndNotY, freqNotXAndNotY)) {
                double chiSquare = Math.pow(freqXAndY * freqNotXAndNotY - freqXAndNotY * freqNotXAndY, 2.0) * (freqXAndY + freqXAndNotY + freqNotXAndY + freqNotXAndNotY) / ((freqXAndY + freqXAndNotY) * (freqNotXAndY + freqNotXAndNotY) * (freqXAndNotY + freqNotXAndNotY) * (freqXAndY + freqNotXAndY));
                return chiSquare;
            }
            double total = freqXAndY + freqXAndNotY + freqNotXAndY + freqNotXAndNotY;
            double chiSquare = total * Math.pow(freqXAndY * freqNotXAndNotY - freqXAndNotY * freqNotXAndY - total / 2.0, 2.0) / ((freqXAndY + freqXAndNotY) * (freqNotXAndY + freqNotXAndNotY) * (freqXAndNotY + freqNotXAndNotY) * (freqXAndY + freqNotXAndY));
            return chiSquare;
        }
        return 0.0;
    }

    private static boolean checkForChi2Reliablity(double freqXAndY, double freqNotXAndY, double freqXAndNotY, double freqNotXAndNotY) {
        double total = freqXAndY + freqXAndNotY + freqNotXAndY + freqNotXAndNotY;
        double freqX = freqXAndY + freqXAndNotY;
        double freqNX = freqNotXAndY + freqNotXAndNotY;
        double freqY = freqXAndY + freqNotXAndY;
        double freqNY = freqXAndNotY + freqNotXAndNotY;
        double expXY = freqX * freqY / total;
        double expNXY = freqNX * freqY / total;
        double expXNY = freqX * freqNY / total;
        double expNXNY = freqNX * freqNY / total;
        return expXY >= 5.0 && expNXY >= 5.0 && expXNY >= 5.0 && expNXNY >= 5.0;
    }

    public static double computePhiCoefficient(double freqXAndY, double freqNotXAndY, double freqXAndNotY, double freqNotXAndNotY) {
        double freqX = freqXAndY + freqXAndNotY;
        double freqNotX = freqNotXAndY + freqNotXAndNotY;
        double freqY = freqXAndY + freqNotXAndY;
        double freqNotY = freqXAndNotY + freqNotXAndNotY;
        if (freqX >= 6.0 && freqNotX >= 6.0 && freqY >= 6.0 && freqNotY >= 6.0) {
            double epsilon = 0.05;
            double correlationCoeff = (freqXAndY * freqNotXAndNotY - freqXAndNotY * freqNotXAndY) / Math.sqrt((freqXAndY + freqXAndNotY) * (freqNotXAndY + freqNotXAndNotY) * (freqXAndNotY + freqNotXAndNotY) * (freqXAndY + freqNotXAndY));
            if (correlationCoeff > 1.0 + epsilon) {
                throw new RuntimeException("CorrelationCoeff > 1!");
            }
            if (correlationCoeff == 0.0) {
                if (freqXAndY > 0.0 && freqNotXAndNotY == 0.0) {
                    return 1.0;
                }
                if (freqNotXAndY > 0.0 && freqXAndNotY == 0.0) {
                    return -1.0;
                }
                if (freqXAndNotY > 0.0 && freqNotXAndY == 0.0) {
                    return -1.0;
                }
            }
            return correlationCoeff;
        }
        return 0.0;
    }
}

