/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.persistence;

import java.text.ParseException;
import java.util.logging.Logger;
import org.vikamine.kernel.data.AttributeProvider;
import org.vikamine.kernel.data.DerivedNominalAttribute;
import org.vikamine.kernel.data.Ontology;
import org.vikamine.kernel.data.Value;
import org.vikamine.kernel.persistence.DiscretizedSelectorMarshaller;
import org.vikamine.kernel.persistence.NegatedSelectorMarshaller;
import org.vikamine.kernel.persistence.SGSelectorMarshaller;
import org.vikamine.kernel.persistence.SelectorMarshaller;
import org.vikamine.kernel.subgroup.selectors.NegatedSGSelector;
import org.vikamine.kernel.subgroup.selectors.SGNominalSelector;
import org.vikamine.kernel.subgroup.selectors.SGSelector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SelectorPersistenceManager {
    public Element marshall(SGSelector selector, Document document) {
        Element elem = document.createElement("selector");
        SelectorMarshaller marshaller = this.getMarshaller(selector);
        elem.setAttribute("type", marshaller.getClass().getName());
        marshaller.marshall(selector, elem, document);
        return elem;
    }

    public SGSelector unmarshall(Element element, AttributeProvider attributeProvider, Ontology ontology) throws ParseException {
        String type = element.getAttribute("type");
        SelectorMarshaller marshaller = this.createMarshaller(type);
        return marshaller.unmarshall(element, attributeProvider, ontology);
    }

    protected SelectorMarshaller getMarshaller(SGSelector sel) {
        if (sel instanceof NegatedSGSelector) {
            return new NegatedSelectorMarshaller();
        }
        if (sel.getAttribute() instanceof DerivedNominalAttribute && !((SGNominalSelector)sel).getValues().isEmpty() && ((SGNominalSelector)sel).getValues().toArray()[0] instanceof Value.CustomDiscretizedValue) {
            return new DiscretizedSelectorMarshaller();
        }
        return new SGSelectorMarshaller();
    }

    protected SelectorMarshaller createMarshaller(String type) throws ParseException {
        try {
            Object obj = Class.forName(type).newInstance();
            return (SelectorMarshaller)obj;
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).throwing(this.getClass().getName(), "createMarshaller", e);
            throw new ParseException("unknown selector-type: " + type, 0);
        }
    }
}

