/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.formula.operators;

import java.util.HashSet;
import java.util.Set;
import org.vikamine.kernel.formula.EvaluationData;
import org.vikamine.kernel.formula.FormulaNumber;
import org.vikamine.kernel.formula.FormulaNumberElement;
import org.vikamine.kernel.formula.operators.AbstractNumberArgumentTerm;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractTwoNumberArgumentsTerm
extends AbstractNumberArgumentTerm {
    protected FormulaNumberElement arg2 = null;
    protected Double evaluatedArg2 = null;

    public AbstractTwoNumberArgumentsTerm() {
    }

    public AbstractTwoNumberArgumentsTerm(String symb) {
        super(symb);
    }

    public AbstractTwoNumberArgumentsTerm(FormulaNumberElement arg1, FormulaNumberElement arg2) {
        this.setArg1(arg1);
        this.setArg2(arg2);
    }

    public Double evalArgument2(EvaluationData data) {
        if (this.getArg2() == null) {
            return null;
        }
        this.evaluatedArg2 = this.getArg2().eval(data);
        if (this.getEvaluatedArg2() == null) {
            return null;
        }
        return this.getEvaluatedArg2();
    }

    @Override
    public boolean evalArguments(EvaluationData data) {
        if (!super.evalArguments(data)) {
            return false;
        }
        return this.evalArgument2(data) != null;
    }

    public FormulaNumberElement getArg2() {
        if (this.arg2 == null) {
            return new FormulaNumber(null);
        }
        return this.arg2;
    }

    public Double getEvaluatedArg2() {
        return this.evaluatedArg2;
    }

    public void setArg2(FormulaNumberElement arg2) {
        this.arg2 = arg2;
    }

    @Override
    public String toString() {
        return "(" + (this.getArg1() != null ? this.getArg1().toString() : "") + " " + this.getSymbol() + " " + (this.getArg2() != null ? this.getArg2().toString() : "") + ")";
    }

    @Override
    public Set getAttributes() {
        HashSet set1 = super.getAttributes();
        Set set2 = this.getArg2().getAttributes();
        HashSet result = set1;
        if (!(result instanceof HashSet)) {
            result = new HashSet(set1);
        }
        result.addAll(set2);
        return result;
    }

    @Override
    public Element createDOMNode(Document doc) {
        Element elem = super.createDOMNode(doc);
        if (this.getArg2() != null) {
            Element arg2Node = this.getArg2().createDOMNode(doc);
            arg2Node.setAttribute("argIndex", "2");
            elem.appendChild(arg2Node);
        }
        return elem;
    }

    @Override
    public boolean equals(Object other) {
        return this.isEqual(other);
    }

    @Override
    public int hashCode() {
        return this.computeHashCode();
    }

    @Override
    public int computeHashCode() {
        return this.getArg1().hashCode() + this.getArg2().hashCode();
    }

    @Override
    public boolean isEqual(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        AbstractTwoNumberArgumentsTerm term2 = (AbstractTwoNumberArgumentsTerm)other;
        return this.getArg1().equals(term2.getArg1()) && this.getArg2().equals(term2.getArg2());
    }
}

