/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.formula.constants;

import java.util.Collections;
import java.util.Set;
import org.vikamine.kernel.data.Value;
import org.vikamine.kernel.formula.FormulaElement;
import org.vikamine.kernel.persistence.ValuesMarshaller;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FormulaAttributeValuePrimitive
implements FormulaElement {
    private Value value;
    private String name;

    protected FormulaAttributeValuePrimitive() {
    }

    public FormulaAttributeValuePrimitive(Value value) {
        this.value = value;
    }

    @Override
    public Set getAttributes() {
        return Collections.EMPTY_SET;
    }

    public Value getValue() {
        return this.value;
    }

    public void setValue(Value value) {
        this.value = value;
    }

    @Override
    public Element createDOMNode(Document doc) {
        Element elem = doc.createElement("formula");
        elem.setAttribute("symbol", "attributeValue");
        elem.setAttribute("attribute", this.value.getAttribute().getId());
        Element valueElement = doc.createElement("attributeValue");
        elem.appendChild(valueElement);
        new ValuesMarshaller().createValueNode(doc, valueElement, this.getValue());
        return elem;
    }

    public String toString() {
        return this.value == null ? "" : (this.name == null ? this.value.getDescription() : this.getName());
    }

    public boolean equals(Object other) {
        return this.isEqual(other);
    }

    public boolean isEqual(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        return this.value.equals(((FormulaAttributeValuePrimitive)other).value);
    }

    public int hashCode() {
        return this.computeHashCode();
    }

    public int computeHashCode() {
        return this.value.hashCode();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

