/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.dmg.pmml.Version;

public class VersionUtil {
    private static Map<String, Version> functionVersions = new LinkedHashMap<String, Version>();

    private VersionUtil() {
    }

    public static int compare(int[] left, int[] right) {
        int max = Math.max(left.length, right.length);
        for (int i = 0; i < max; ++i) {
            int diff = Integer.compare(left[i], right[i]);
            if (diff == 0) continue;
            return diff;
        }
        return 0;
    }

    public static int compare(String left, String right) {
        return VersionUtil.compare(VersionUtil.parse(left), VersionUtil.parse(right));
    }

    public static int[] parse(String string) {
        StringTokenizer st = new StringTokenizer(string, ".");
        int[] result = new int[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            result[i] = Integer.parseInt(st.nextToken());
            ++i;
        }
        return result;
    }

    public static Version getVersion(String function) {
        return functionVersions.get(function);
    }

    private static void declareFunctions(Version version, String ... functions) {
        for (String function : functions) {
            functionVersions.put(function, version);
        }
    }

    static {
        VersionUtil.declareFunctions(Version.PMML_3_0, "+", "-", "*", "/", "min", "max", "sum", "avg", "log10", "ln", "sqrt", "abs", "uppercase", "substring", "trimBlanks", "formatNumber", "formatDatetime", "dateDaysSinceYear", "dateSecondsSinceYear", "dateSecondsSinceMidnight");
        VersionUtil.declareFunctions(Version.PMML_3_1, "exp", "pow", "threshold", "floor", "ceil", "round");
        VersionUtil.declareFunctions(Version.PMML_4_0, "isMissing", "isNotMissing", "equal", "notEqual", "lessThan", "lessOrEqual", "greaterThan", "greaterOrEqual", "and", "or", "not", "isIn", "isNotIn", "if");
        VersionUtil.declareFunctions(Version.PMML_4_1, "median", "product", "lowercase");
        VersionUtil.declareFunctions(Version.PMML_4_2, "concat", "replace", "matches");
        VersionUtil.declareFunctions(Version.PMML_4_3, "normalCDF", "normalPDF", "stdNormalCDF", "stdNormalPDF", "erf", "normalIDF", "stdNormalIDF");
        VersionUtil.declareFunctions(Version.PMML_4_4, "modulo", "isValid", "isNotValid", "expm1", "hypot", "ln1p", "rint", "stringLength", "sin", "asin", "sinh", "cos", "acos", "cosh", "tan", "atan", "tanh");
        VersionUtil.declareFunctions(Version.XPMML, "x-atan2");
    }
}

