/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.rexp;

import java.util.Arrays;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Field;
import org.dmg.pmml.Model;
import org.dmg.pmml.OpType;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.mining.Segmentation;
import org.dmg.pmml.regression.RegressionModel;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.ContinuousLabel;
import org.jpmml.converter.DerivedOutputField;
import org.jpmml.converter.Feature;
import org.jpmml.converter.ModelEncoder;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.ScalarLabel;
import org.jpmml.converter.Schema;
import org.jpmml.converter.mining.MiningModelUtil;
import org.jpmml.converter.regression.RegressionModelUtil;
import org.jpmml.rexp.LMConverter;
import org.jpmml.rexp.RExpEncoder;
import org.jpmml.rexp.RGenericVector;
import org.jpmml.rexp.RNumberVector;
import org.jpmml.rexp.RStringVector;

public class POLRConverter
extends LMConverter {
    public POLRConverter(RGenericVector polr) {
        super(polr);
    }

    @Override
    public void encodeSchema(RExpEncoder encoder) {
        RGenericVector polr = (RGenericVector)this.getObject();
        RStringVector lev = polr.getStringElement("lev");
        super.encodeSchema(encoder);
        ScalarLabel scalarLabel = (ScalarLabel)encoder.getLabel();
        DataField dataField = (DataField)encoder.toOrdinal(scalarLabel.getName(), lev.getValues());
        encoder.setLabel(dataField);
    }

    @Override
    public Model encodeModel(Schema schema) {
        RGenericVector polr = (RGenericVector)this.getObject();
        RStringVector method = polr.getStringElement("method");
        RNumberVector<?> zeta = polr.getNumericElement("zeta");
        ModelEncoder encoder = schema.getEncoder();
        Schema segmentSchema = schema.toAnonymousRegressorSchema(DataType.DOUBLE);
        RegressionModel firstRegressionModel = (RegressionModel)super.encodeModel(segmentSchema).setTargets(ModelUtil.createRescaleTargets((Number)-1.0, null, (ContinuousLabel)((ContinuousLabel)segmentSchema.getLabel())));
        OutputField linpredOutputField = ModelUtil.createPredictedField((String)"linpred", (OpType)OpType.CONTINUOUS, (DataType)DataType.DOUBLE);
        DerivedOutputField linpredField = encoder.createDerivedField((Model)firstRegressionModel, linpredOutputField, true);
        ContinuousFeature feature = new ContinuousFeature((PMMLEncoder)encoder, (Field)linpredField);
        RegressionModel secondRegressionModel = RegressionModelUtil.createOrdinalClassification((Feature)feature, zeta.getValues(), (RegressionModel.NormalizationMethod)POLRConverter.parseNormalizationMethod((String)method.asScalar()), (boolean)true, (Schema)schema);
        return MiningModelUtil.createModelChain(Arrays.asList(firstRegressionModel, secondRegressionModel), (Segmentation.MissingPredictionTreatment)Segmentation.MissingPredictionTreatment.RETURN_MISSING);
    }

    private static RegressionModel.NormalizationMethod parseNormalizationMethod(String method) {
        switch (method) {
            case "logistic": {
                return RegressionModel.NormalizationMethod.LOGIT;
            }
            case "probit": {
                return RegressionModel.NormalizationMethod.PROBIT;
            }
            case "loglog": {
                return RegressionModel.NormalizationMethod.LOGLOG;
            }
            case "cloglog": {
                return RegressionModel.NormalizationMethod.CLOGLOG;
            }
            case "cauchit": {
                return RegressionModel.NormalizationMethod.CAUCHIT;
            }
        }
        throw new IllegalArgumentException(method);
    }
}

