/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Preprocess.Feature_Selection.evolutionary_algorithms;

import java.util.Vector;
import keel.Algorithms.Preprocess.Feature_Selection.evolutionary_algorithms.Cromosoma;
import org.core.Randomize;

public class CromosomaBinario
extends Cromosoma {
    public CromosomaBinario(int tama) {
        super(tama);
    }

    @Override
    public void initRand() {
        for (int i = 0; i < this.tamCromosoma; ++i) {
            this.rep[i] = Randomize.Randint(0, 2);
        }
    }

    @Override
    public void initPlantilla(Cromosoma crPlantilla, double ratio) {
        for (int i = 0; i < this.tamCromosoma; ++i) {
            this.rep[i] = Randomize.RandClosed() <= ratio ? crPlantilla.devolverGen(i) : Randomize.Randint(0, 2);
        }
    }

    @Override
    public int devolverGen(int i) {
        if (i < 0 || i >= this.tamCromosoma) {
            System.err.println("ERROR: Gen i out of chromosome bounds");
            System.exit(0);
        }
        return this.rep[i];
    }

    @Override
    public void cambiarGen(int nuevoValorGen, int posGen) {
        if (posGen < 0 || posGen >= this.rep.length) {
            System.err.println("ERROR: Gen 'posGen' out of chromosome bounds");
            System.exit(0);
        }
        if (nuevoValorGen != 0 && nuevoValorGen != 1) {
            System.err.println("ERROR: This is a binary chromosome, therefore it only contains binary values {0,1}");
            System.exit(0);
        }
        this.rep[posGen] = nuevoValorGen;
    }

    @Override
    public void cruzar(Cromosoma padre2, Cromosoma hijo1, Cromosoma hijo2) {
        int i;
        if (padre2 == null) {
            System.err.println("ERROR: padre2 doesn't exist");
            System.exit(0);
        }
        int puntoCorte = Randomize.Randint(0, this.tamCromosoma);
        int[] vectorAux = new int[this.tamCromosoma];
        for (i = 0; i < puntoCorte; ++i) {
            vectorAux[i] = this.rep[i];
        }
        for (i = puntoCorte; i < this.tamCromosoma; ++i) {
            vectorAux[i] = padre2.devolverGen(i);
        }
        for (i = 0; i < this.tamCromosoma; ++i) {
            hijo1.cambiarGen(vectorAux[i], i);
        }
        for (i = 0; i < puntoCorte; ++i) {
            vectorAux[i] = padre2.devolverGen(i);
        }
        for (i = puntoCorte; i < this.tamCromosoma; ++i) {
            vectorAux[i] = this.rep[i];
        }
        for (i = 0; i < this.tamCromosoma; ++i) {
            hijo2.cambiarGen(vectorAux[i], i);
        }
    }

    @Override
    public boolean cruzarHUX(Cromosoma padre2, Cromosoma hijo1, Cromosoma hijo2, int umbral) {
        int i;
        Vector<Integer> v = new Vector<Integer>();
        if (padre2 == null) {
            System.err.println("ERROR: padre2 doesn't exist");
            System.exit(0);
        }
        for (i = 0; i < this.tamCromosoma; ++i) {
            if (this.rep[i] == padre2.devolverGen(i)) continue;
            v.addElement(i);
        }
        if (v.size() < umbral) {
            return false;
        }
        hijo1.copy(this);
        hijo2.copy(padre2);
        hijo1.setFitness(-1.0);
        hijo2.setFitness(-1.0);
        int nGenesACruzar = v.size() / 2;
        for (i = 0; i < nGenesACruzar; ++i) {
            int posACruzar = (Integer)v.remove(Randomize.Randint(0, v.size()));
            int aux = hijo1.devolverGen(posACruzar);
            hijo1.cambiarGen(hijo2.devolverGen(posACruzar), posACruzar);
            hijo2.cambiarGen(aux, posACruzar);
        }
        return true;
    }

    @Override
    public void mutar() {
        int puntoAleat = Randomize.Randint(0, this.tamCromosoma);
        this.rep[puntoAleat] = this.rep[puntoAleat] == 0 ? 1 : 0;
        this.fitness = -1.0;
    }

    @Override
    public String print() {
        String res = new String();
        for (int i = 0; i < this.tamCromosoma; ++i) {
            res = res + String.valueOf(this.rep[i]);
        }
        return res;
    }

    @Override
    public boolean[] devolverFeaturesVector() {
        boolean[] featuresVector = new boolean[this.tamCromosoma];
        for (int i = 0; i < this.tamCromosoma; ++i) {
            featuresVector[i] = this.rep[i] == 1;
        }
        return featuresVector;
    }
}

