/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Associative_Classification.ClassifierFuzzyFCRA;

import keel.Algorithms.Associative_Classification.ClassifierFuzzyFCRA.Fuzzy;
import keel.Algorithms.Associative_Classification.ClassifierFuzzyFCRA.myDataset;
import org.core.Files;

public class DataBase {
    int n_variables;
    int partitions;
    int[] nLabels;
    Fuzzy[][] dataBase;
    String[] names;

    public DataBase() {
    }

    public DataBase(int nLabels, myDataset train) {
        double[][] ranks = train.devuelveRangos();
        this.n_variables = train.getnInputs();
        this.names = (String[])train.names().clone();
        this.nLabels = new int[this.n_variables];
        this.dataBase = new Fuzzy[this.n_variables][];
        for (int i = 0; i < this.n_variables; ++i) {
            double rank = Math.abs(ranks[i][1] - ranks[i][0]);
            this.nLabels[i] = train.isNominal(i) ? (int)rank + 1 : nLabels;
            this.dataBase[i] = new Fuzzy[this.nLabels[i]];
            double mark = rank / ((double)this.nLabels[i] - 1.0);
            for (int j = 0; j < this.nLabels[i]; ++j) {
                this.dataBase[i][j] = new Fuzzy();
                double value = ranks[i][0] + mark * (double)(j - 1);
                this.dataBase[i][j].x0 = this.setValue(value, ranks[i][0], ranks[i][1]);
                value = ranks[i][0] + mark * (double)j;
                this.dataBase[i][j].x1 = this.setValue(value, ranks[i][0], ranks[i][1]);
                value = ranks[i][0] + mark * (double)(j + 1);
                this.dataBase[i][j].x3 = this.setValue(value, ranks[i][0], ranks[i][1]);
                this.dataBase[i][j].y = 1.0;
                this.dataBase[i][j].name = new String("L_" + j + "(" + this.nLabels[i] + ")");
            }
        }
    }

    private double setValue(double val, double min, double tope) {
        if (val > min - 1.0E-4 && val < min + 1.0E-4) {
            return min;
        }
        if (val > tope - 1.0E-4 && val < tope + 1.0E-4) {
            return tope;
        }
        return val;
    }

    public int numVariables() {
        return this.n_variables;
    }

    public int numLabels(int variable) {
        return this.nLabels[variable];
    }

    public int[] getnLabels() {
        return this.nLabels;
    }

    public double matching(int variable, int label, double value) {
        if (variable < 0 || label < 0) {
            return 1.0;
        }
        return this.dataBase[variable][label].Fuzzifica(value);
    }

    public String print_triangle(int var, int label) {
        String cadena = new String("");
        Fuzzy d = this.dataBase[var][label];
        cadena = d.name + ": \t" + d.x0 + "\t" + d.x1 + "\t" + d.x3 + "\n";
        return cadena;
    }

    public String print(int var, int label) {
        return this.dataBase[var][label].getName();
    }

    public String printString() {
        String string = new String("@Using Triangular Membership Functions as antecedent fuzzy sets");
        for (int i = 0; i < this.n_variables; ++i) {
            string = string + "\n\n@Number of Labels in Variable " + (i + 1) + ": " + this.nLabels[i];
            string = string + "\n" + this.names[i] + ":\n";
            for (int j = 0; j < this.nLabels[i]; ++j) {
                string = string + this.dataBase[i][j].name + ": (" + this.dataBase[i][j].x0 + "," + this.dataBase[i][j].x1 + "," + this.dataBase[i][j].x3 + ")\n";
            }
        }
        return string;
    }

    public void saveFile(String filename) {
        String stringOut = new String("");
        stringOut = this.printString();
        Files.writeFile(filename, stringOut);
    }
}

