% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dose-response-analysis.R
\name{growth.drFitSpline}
\alias{growth.drFitSpline}
\title{Perform a smooth spline fit on response vs. concentration data of a single sample to determine the EC50.}
\usage{
growth.drFitSpline(conc, test, drID = "undefined", control = growth.control())
}
\arguments{
\item{conc}{Vector of concentration values.}

\item{test}{Vector of response parameter values of the same length as \code{conc}.}

\item{drID}{(Character) The name of the analyzed condition}

\item{control}{A \code{grofit.control} object created with \code{\link{growth.control}}, defining relevant fitting options.}
}
\value{
A \code{drFitSpline} object.
\item{raw.conc}{Raw data provided to the function as \code{conc}.}
\item{raw.test}{Raw data for the response parameter provided to the function as \code{test}.}
\item{drID}{(Character) Identifies the tested condition}
\item{fit.conc}{Fitted concentration values.}
\item{fit.test}{Fitted response values.}
\item{spline}{\code{smooth.spline} object generated by the \code{\link{smooth.spline}} function.}
\item{spline.low}{\code{x} and {y} values of \code{\link{lowess}} spline fit on raw data. Used to call \code{\link{smooth.spline}}.}
\item{parameters}{List of parameters estimated from dose response curve fit.}
\itemize{
\item \code{EC50}: {Concentration at half-maximal response.}
\item \code{yEC50}: {Response value related to EC50.}
\item \code{EC50.orig}: {EC50 value in original scale, if a transformation was applied.}
\item \code{yEC50.orig}: {Response value for EC50 in original scale, if a transformation was applied.}
}
\item{fitFlag}{(Logical) Indicates whether a spline could fitted successfully to data.}
\item{reliable}{(Logical) Indicates whether the performed fit is reliable (to be set manually).}
\item{control}{Object of class \code{grofit.control} containing list of options passed to the function as \code{control}.}
Use \code{\link{plot.drFitSpline}} to visualize the spline fit.
}
\description{
\code{growth.drFitSpline} performs a smooth spline fit determines the EC50 as the concentration
at the half-maximum value of the response parameter of the spline.
}
\details{
During the spline fit with \code{\link{smooth.spline}}, higher weights are
assigned to data points with a concentration value of 0, as well as to x-y pairs with
a response parameter value of 0 and pairs at concentration values before
zero-response parameter values.
}
\examples{
conc <- c(0, rev(unlist(lapply(1:18, function(x) 10*(2/3)^x))),10)
response <- c(1/(1+exp(-0.7*(4-conc[-20])))+rnorm(19)/50, 0)

TestRun <- growth.drFitSpline(conc, response, drID = 'test',
              control = growth.control(log.x.dr = TRUE, smooth.dr = 0.8))

print(summary(TestRun))

plot(TestRun)
}
\references{
Matthias Kahm, Guido Hasenbrink, Hella Lichtenberg-Frate, Jost Ludwig, Maik Kschischo (2010). \emph{grofit: Fitting Biological Growth Curves with R}. Journal of Statistical Software, 33(7), 1-21. DOI: 10.18637/jss.v033.i07

Christian Ritz, Florent Baty, Jens C. Streibig, Daniel Gerhard (2015). \emph{Dose-Response Analysis Using R}. PLoS ONE 10(12): e0146021. DOI: 10.1371/journal.pone.0146021
}
\seealso{
Other dose-response analysis functions: 
\code{\link{flFit}()},
\code{\link{growth.drBootSpline}()},
\code{\link{growth.gcFit}()},
\code{\link{growth.workflow}()}
}
\concept{dose-response analysis functions}
