/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.util;

import java.io.Serializable;
import umontreal.iro.lecuyer.util.BitVector;
import umontreal.iro.lecuyer.util.PrintfFormat;

public class BitMatrix
implements Serializable,
Cloneable {
    static final long serialVersionUID = 2472769969919959608L;
    private BitVector[] rows;
    private int r;
    private int c;

    public BitMatrix(int r, int c) {
        this.rows = new BitVector[r];
        for (int i = 0; i < r; ++i) {
            this.rows[i] = new BitVector(c);
        }
        this.r = r;
        this.c = c;
    }

    public BitMatrix(BitVector[] rows) {
        this.rows = new BitVector[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            this.rows[i] = new BitVector(rows[i]);
        }
        this.r = rows.length;
        this.c = this.r > 0 ? rows[0].size() : 0;
    }

    public BitMatrix(int[][] data, int r, int c) {
        this.rows = new BitVector[r];
        for (int i = 0; i < r; ++i) {
            this.rows[i] = new BitVector(data[i], c);
        }
        this.r = r;
        this.c = c;
    }

    public BitMatrix(BitMatrix that) {
        this.r = that.r;
        this.c = that.c;
        this.rows = new BitVector[this.r];
        for (int i = 0; i < this.r; ++i) {
            this.rows[i] = new BitVector(that.rows[i]);
        }
    }

    public Object clone() {
        try {
            BitMatrix c = (BitMatrix)super.clone();
            c.rows = (BitVector[])this.rows.clone();
            for (int i = 0; i < this.rows.length; ++i) {
                c.rows[i] = (BitVector)this.rows[i].clone();
            }
            return c;
        }
        catch (CloneNotSupportedException e) {
            IllegalStateException ne = new IllegalStateException();
            ne.initCause(e);
            throw ne;
        }
    }

    public boolean equals(BitMatrix that) {
        if (this.r != that.r || this.c != that.c) {
            return false;
        }
        for (int i = 0; i < this.r; ++i) {
            if (this.rows[i].equals(that.rows[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{ ");
        for (int i = 0; i < this.rows.length - 1; ++i) {
            for (int j = 0; j < this.rows[i].size(); ++j) {
                sb.append(this.rows[i].getBool(j) ? "1" : "0");
            }
            sb.append(PrintfFormat.NEWLINE + "  ");
        }
        if (this.r > 0) {
            for (int j = 0; j < this.c; ++j) {
                sb.append(this.rows[this.r - 1].getBool(j) ? "1" : "0");
            }
            sb.append(" }");
        } else {
            sb.append(" }");
        }
        return sb.toString();
    }

    public String printData() {
        StringBuffer sb = new StringBuffer();
        sb.append("{ ");
        for (int i = 0; i < this.r; ++i) {
            sb.append("{");
            for (int j = 0; j < (this.c + 31) / 32; ++j) {
                sb.append(this.rows[i].getInt(j));
                if (j == (this.c - 1) / 32) continue;
                sb.append(", ");
            }
            sb.append("}");
            if (i == this.r - 1) continue;
            sb.append("," + PrintfFormat.NEWLINE + "  ");
        }
        sb.append(" }");
        return sb.toString();
    }

    public int numRows() {
        return this.r;
    }

    public int numColumns() {
        return this.c;
    }

    public boolean getBool(int row, int column) {
        if (row >= this.r || column >= this.c) {
            throw new IndexOutOfBoundsException();
        }
        return this.rows[row].getBool(column);
    }

    public void setBool(int row, int column, boolean value) {
        if (row >= this.r || column >= this.c) {
            throw new IndexOutOfBoundsException();
        }
        this.rows[row].setBool(column, value);
    }

    public BitMatrix transpose() {
        BitMatrix result = new BitMatrix(this.c, this.r);
        for (int i = 0; i < this.r; ++i) {
            for (int j = 0; j < this.c; ++j) {
                result.rows[j].setBool(i, this.rows[i].getBool(j));
            }
        }
        return result;
    }

    public BitMatrix not() {
        BitMatrix result = new BitMatrix(this);
        for (int i = 0; i < this.r; ++i) {
            result.rows[i].selfNot();
        }
        return result;
    }

    public BitMatrix and(BitMatrix that) {
        if (this.c != that.c || this.r != that.r) {
            throw new IncompatibleDimensionException("Both matrices must have the same dimension. this is a " + this.r + "x" + this.c + " matrix " + "while that is a " + that.r + "x" + that.c + " matrix.");
        }
        BitMatrix result = new BitMatrix(this);
        for (int i = 0; i < this.r; ++i) {
            result.rows[i].selfAnd(that.rows[i]);
        }
        return result;
    }

    public BitMatrix or(BitMatrix that) {
        if (this.c != that.c || this.r != that.r) {
            throw new IncompatibleDimensionException("Both matrices must have the same dimension. this is a " + this.r + "x" + this.c + " matrix " + "while that is a " + that.r + "x" + that.c + " matrix.");
        }
        BitMatrix result = new BitMatrix(this);
        for (int i = 0; i < this.r; ++i) {
            result.rows[i].selfOr(that.rows[i]);
        }
        return result;
    }

    public BitMatrix xor(BitMatrix that) {
        if (this.c != that.c || this.r != that.r) {
            throw new IncompatibleDimensionException("Both matrices must have the same dimension. this is a " + this.r + "x" + this.c + " matrix " + "while that is a " + that.r + "x" + that.c + " matrix.");
        }
        BitMatrix result = new BitMatrix(this);
        for (int i = 0; i < this.r; ++i) {
            result.rows[i].selfXor(that.rows[i]);
        }
        return result;
    }

    public BitVector multiply(BitVector vect) {
        BitVector res = new BitVector(this.r);
        for (int i = 0; i < this.r; ++i) {
            res.setBool(i, this.rows[i].scalarProduct(vect));
        }
        return res;
    }

    public int multiply(int vect) {
        BitVector temp = new BitVector(new int[]{vect});
        return this.multiply(temp).getInt(0);
    }

    public BitMatrix multiply(BitMatrix that) {
        if (this.c != that.r) {
            throw new IncompatibleDimensionException("The number of columns of this (" + this.c + ") must be equal to the number of rows of that (" + that.r + ").");
        }
        BitMatrix res = new BitMatrix(this.r, that.c);
        for (int i = 0; i < res.r; ++i) {
            for (int j = 0; j < res.c; ++j) {
                if (!this.rows[i].getBool(j)) continue;
                res.rows[i].selfXor(that.rows[j]);
            }
        }
        return res;
    }

    public BitMatrix power(long p) {
        if (this.c != this.r) {
            throw new IncompatibleDimensionException("Only square matrices can be raised to a power.");
        }
        if (p < 0L) {
            throw new IllegalArgumentException("Only non-negative powers are accepted.");
        }
        if (p == 0L) {
            BitMatrix bm = new BitMatrix(this.r, this.r);
            for (int i = 0; i < this.r; ++i) {
                bm.setBool(i, i, true);
            }
            return bm;
        }
        if (p == 1L) {
            return this;
        }
        if (p % 2L == 0L) {
            BitMatrix temp = this.power(p / 2L);
            return temp.multiply(temp);
        }
        return this.multiply(this.power(p - 1L));
    }

    public BitMatrix power2e(int e) {
        if (this.c != this.r) {
            throw new IncompatibleDimensionException("Only square matrices can be raised to a power.");
        }
        BitMatrix result = this;
        for (int i = 0; i < e; ++i) {
            result = result.multiply(result);
        }
        return result;
    }

    public class IncompatibleDimensionException
    extends RuntimeException {
        private IncompatibleDimensionException() {
        }

        private IncompatibleDimensionException(String message) {
            super(message);
        }
    }
}

