/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.rng;

import umontreal.iro.lecuyer.rng.CloneableRandomStream;
import umontreal.iro.lecuyer.rng.RandomStreamBase;
import umontreal.iro.lecuyer.util.PrintfFormat;

public class MT19937
extends RandomStreamBase {
    private static final long serialVersionUID = 70510L;
    private static final double NORM = 2.3283064359965952E-10;
    private static final int N = 624;
    private static final int M = 397;
    private static final int[] MULT_MATRIX_A = new int[]{0, -1727483681};
    private static final int UPPER_MASK = Integer.MIN_VALUE;
    private static final int LOWER_MASK = Integer.MAX_VALUE;
    private int[] state;
    private int state_i;
    private CloneableRandomStream seedRng;

    private void fillSeed() {
        this.state_i = 624;
        for (int i = 0; i < 624; ++i) {
            this.state[i] = (int)(this.seedRng.nextDouble() * 4.294967296E9);
        }
    }

    public MT19937(CloneableRandomStream rng) {
        this.seedRng = rng;
        this.name = null;
        this.state = new int[624];
        this.resetStartStream();
    }

    public MT19937(CloneableRandomStream rng, String name) {
        this(rng);
        this.name = name;
    }

    public MT19937 clone() {
        MT19937 retour = null;
        retour = (MT19937)super.clone();
        retour.state = new int[624];
        for (int i = 0; i < 624; ++i) {
            retour.state[i] = this.state[i];
        }
        retour.seedRng = this.seedRng.clone();
        return retour;
    }

    public void resetStartStream() {
        this.seedRng.resetStartStream();
        this.fillSeed();
    }

    public void resetStartSubstream() {
        this.seedRng.resetStartSubstream();
        this.fillSeed();
    }

    public void resetNextSubstream() {
        this.seedRng.resetNextSubstream();
        this.fillSeed();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.name == null) {
            sb.append("This MT19937 ");
        } else {
            sb.append(this.name + " ");
        }
        sb.append("has a " + this.seedRng.getClass() + " for its seed." + PrintfFormat.NEWLINE);
        sb.append("State = [");
        for (int i = 0; i < 623; ++i) {
            sb.append(this.state[i] + ",");
        }
        sb.append(this.state[623] + "]. ");
        sb.append("State index = " + this.state_i);
        return sb.toString();
    }

    protected double nextValue() {
        int y;
        if (this.state_i >= 624) {
            int kk;
            for (kk = 0; kk < 227; ++kk) {
                y = this.state[kk] & Integer.MIN_VALUE | this.state[kk + 1] & Integer.MAX_VALUE;
                this.state[kk] = this.state[kk + 397] ^ y >>> 1 ^ MULT_MATRIX_A[y & 1];
            }
            while (kk < 623) {
                y = this.state[kk] & Integer.MIN_VALUE | this.state[kk + 1] & Integer.MAX_VALUE;
                this.state[kk] = this.state[kk + -227] ^ y >>> 1 ^ MULT_MATRIX_A[y & 1];
                ++kk;
            }
            y = this.state[623] & Integer.MIN_VALUE | this.state[0] & Integer.MAX_VALUE;
            this.state[623] = this.state[396] ^ y >>> 1 ^ MULT_MATRIX_A[y & 1];
            this.state_i = 0;
        }
        y = this.state[this.state_i++];
        y ^= y >>> 11;
        y ^= y << 7 & 0x9D2C5680;
        y ^= y << 15 & 0xEFC60000;
        long r = (y ^= y >>> 18) <= 0 ? (long)y + 0x100000000L : (long)y;
        return (double)r * 2.3283064359965952E-10;
    }
}

