/*
 * Decompiled with CFR 0.152.
 */
package javalain.algorithmegenetique;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Comparator;
import javalain.algorithmegenetique.Chromosome;
import javalain.algorithmegenetique.Population;
import javalain.math.PseudoRandomNumbers;
import util.GuiUtils;

public abstract class Genome
implements Cloneable,
Serializable,
Comparator<Genome> {
    protected static DecimalFormat DF = GuiUtils.DECIMAL_3;
    private Chromosome[] tabChromo;
    private int nbChromo;
    protected Population population;
    private int nbNotes;
    protected double[] notes;

    public Genome(int nbC) {
        if (nbC <= 0) {
            throw new IllegalArgumentException("Genome, Genome (int nbC) : le nombre de chromosome doit \u00eatre > 0.");
        }
        this.nbChromo = nbC;
        this.tabChromo = new Chromosome[nbC];
        this.nbNotes = 1;
        this.notes = new double[1];
    }

    public Genome(int nbC, int nbObjectif) {
        if (nbC <= 0) {
            throw new IllegalArgumentException("Genome, Genome (int nbC, int nbOjectif) : le nombre de chromosome doit \u00eatre > 0.");
        }
        this.nbChromo = nbC;
        this.tabChromo = new Chromosome[nbC];
        if (nbObjectif <= 0) {
            throw new IllegalArgumentException("Genome, Genome (int nbC, int nbOjectif) : le nombre d'objectif doit \u00eatre > 0.");
        }
        this.nbNotes = nbObjectif;
        this.notes = new double[this.nbNotes];
    }

    public void setNote(double d) {
        this.notes[0] = d;
    }

    public double getNote() {
        return this.notes[0];
    }

    public void setNote(double d, int i) {
        this.notes[i] = d;
    }

    public double getNote(int i) {
        return this.notes[i];
    }

    public int getNbObjectif() {
        return this.nbNotes;
    }

    public void setPopulation(Population p) {
        this.population = p;
    }

    public Population getPopulation() {
        return this.population;
    }

    public void addChromosome(Chromosome ch) {
        int i;
        for (i = 0; i < this.nbChromo && this.tabChromo[i] != null; ++i) {
        }
        if (i == this.nbChromo) {
            throw new IndexOutOfBoundsException("Genome, addChromosome  (Chromosome ch, int mode) : impossible d'ajouter un Chromosome, le Genome est plein.");
        }
        this.tabChromo[i] = ch;
    }

    public Chromosome getChromosome(int i) {
        try {
            return this.tabChromo[i];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException("Genome, getChromosome (int i) : indice 'i' hors des limites.");
        }
    }

    public int size() {
        return this.nbChromo;
    }

    public Genome[] croisement(Genome g) {
        Genome g1;
        Genome g0;
        try {
            g0 = (Genome)this.clone();
            g1 = (Genome)this.clone();
        }
        catch (CloneNotSupportedException x) {
            return null;
        }
        g0.tabChromo = new Chromosome[this.nbChromo];
        g0.notes = new double[this.nbNotes];
        g1.tabChromo = new Chromosome[this.nbChromo];
        g1.notes = new double[this.nbNotes];
        for (int i = 0; i < this.nbChromo; ++i) {
            Chromosome[] ch = this.tabChromo[i].croisement(g.tabChromo[i]);
            g0.tabChromo[i] = ch[0];
            g1.tabChromo[i] = ch[1];
        }
        Genome[] ge = new Genome[]{g0, g1};
        return ge;
    }

    public boolean mutation(double Pm) {
        return this.tabChromo[(int)(PseudoRandomNumbers.random() * (double)this.nbChromo)].mutation(Pm);
    }

    public Genome copier() {
        try {
            Genome g = (Genome)this.clone();
            g.tabChromo = new Chromosome[this.nbChromo];
            g.notes = new double[this.nbNotes];
            for (int i = 0; i < this.nbChromo; ++i) {
                g.tabChromo[i] = this.tabChromo[i].copier();
            }
            System.arraycopy(this.notes, 0, g.notes, 0, this.nbNotes);
            return g;
        }
        catch (CloneNotSupportedException x) {
            return null;
        }
    }

    public Genome creer() {
        try {
            Genome g = (Genome)this.clone();
            g.tabChromo = new Chromosome[this.nbChromo];
            g.notes = new double[this.nbNotes];
            for (int i = 0; i < this.nbChromo; ++i) {
                g.tabChromo[i] = this.tabChromo[i].creer();
            }
            return g;
        }
        catch (CloneNotSupportedException x) {
            return null;
        }
    }

    public StringBuilder afficher() {
        int i;
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < this.nbChromo; ++i) {
            sb.append((CharSequence)this.tabChromo[i].afficher()).append('\n');
        }
        sb.append("Fitness : ");
        for (i = 0; i < this.nbNotes - 1; ++i) {
            sb.append(DF.format(this.notes[i])).append(" ");
        }
        sb.append(DF.format(this.notes[this.nbNotes - 1]));
        return sb;
    }

    public static void setDecimalFormat(DecimalFormat df) {
        DF = df;
    }

    @Override
    public int compare(Genome g1, Genome g2) {
        if (g1.getNote() > g2.getNote()) {
            return 1;
        }
        if (g1.getNote() < g2.getNote()) {
            return -1;
        }
        return 0;
    }

    public final String toString() {
        return this.afficher().toString();
    }

    public double distance(Genome g) {
        return 0.0;
    }

    public boolean dominePareto(Genome g) {
        return false;
    }

    public abstract void fitness();
}

