/*
 * Decompiled with CFR 0.152.
 */
package epp_pso.tribe;

import epp_pso.tribe.ParticuleTribe;
import epp_pso.tribe.Tribu;
import indice.Indice;
import java.util.ArrayList;

public class EssaimTribe {
    private ArrayList<Tribu> swarm = new ArrayList();

    public EssaimTribe(Indice indice) {
        Tribu tr = new Tribu();
        tr.addParticule(new ParticuleTribe(indice));
        this.swarm.add(tr);
    }

    public int getNbTribus() {
        return this.swarm.size();
    }

    public int getNbParticules() {
        int cpt = 0;
        for (int i = 0; i < this.swarm.size(); ++i) {
            cpt += this.swarm.get(i).size();
        }
        return cpt;
    }

    public void updatePbest() {
        for (int i = 0; i < this.swarm.size(); ++i) {
            this.swarm.get(i).updatePbest();
        }
    }

    public void updatePosition(boolean bool, int N) {
        ParticuleTribe g_best = this.getBestParticle().createCopie();
        for (int i = 0; i < this.swarm.size(); ++i) {
            this.swarm.get(i).updatePosition(g_best, bool, N);
        }
    }

    public ParticuleTribe getBestParticle() {
        ParticuleTribe g_best = this.swarm.get(0).getBestParticle();
        double max = g_best.meilleurI;
        for (int i = 1; i < this.swarm.size(); ++i) {
            ParticuleTribe p = this.swarm.get(i).getBestParticle();
            if (!(max < p.meilleurI)) continue;
            max = p.meilleurI;
            g_best = p;
        }
        return g_best;
    }

    public int nbLiens() {
        int cpt_liens = 0;
        for (int i = 0; i < this.swarm.size(); ++i) {
            cpt_liens += this.swarm.get(i).nbLiens();
        }
        return cpt_liens;
    }

    public void supprimePireParticule() {
        for (int i = 0; i < this.swarm.size(); ++i) {
            this.swarm.get(i).supprimePireParticule();
        }
    }

    public void creationTribu(Indice indice) {
        Tribu new_tribe = new Tribu();
        if (this.swarm.size() == 1 || this.swarm.size() == 2) {
            new_tribe.addParticule(new ParticuleTribe(indice));
            new_tribe.addParticule(new ParticuleTribe(indice));
            Tribu tr = this.swarm.get(0);
            new_tribe.addLien(tr);
            tr.addLien(new_tribe);
            this.swarm.add(new_tribe);
        } else {
            for (int i = 0; i < this.swarm.size(); ++i) {
                Tribu tr = this.swarm.get(i);
                if (tr.isPerformante()) continue;
                new_tribe.addParticule(new ParticuleTribe(indice));
                new_tribe.addParticule(new ParticuleTribe(indice, this.getBestParticle(), tr.getBestParticle()));
                new_tribe.addLien(tr);
                tr.addLien(new_tribe);
            }
            if (new_tribe.size() != 0) {
                this.swarm.add(new_tribe);
            }
        }
    }

    public boolean premiereAdaptation() {
        int i;
        for (i = 0; i < this.swarm.size() && this.swarm.get(i).isPerformante(); ++i) {
        }
        return i == this.swarm.size();
    }

    public void adaptation(Indice indice) {
        this.creationTribu(indice);
        this.supprimePireParticule();
    }
}

