/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.rng;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import umontreal.iro.lecuyer.rng.RandomStreamBase;
import umontreal.iro.lecuyer.util.BitMatrix;
import umontreal.iro.lecuyer.util.BitVector;

public class GenF2w32
extends RandomStreamBase {
    private static final long serialVersionUID = 70510L;
    private static final double NORM = 2.3283064359965952E-10;
    private static final int Z0 = Integer.MIN_VALUE;
    private static final int W = 32;
    private static final int R = 25;
    private static final int T = 7;
    private static final int W1 = 11;
    private static final int W2 = 11;
    private static final int W3 = 10;
    private static final int Wsplit1 = 21;
    private static final int Wsplit2 = 10;
    private static final int MASK1 = -2097152;
    private static final int MASK2 = 2096128;
    private static final int MASK3 = 1023;
    private static int[] BrmT1;
    private static int[] BrmT2;
    private static int[] BrmT3;
    private static int[] Br1;
    private static int[] Br2;
    private static int[] Br3;
    private static final int BrmT = -425292512;
    private static final int Br = 679131202;
    private static final int modQ = -95446209;
    private static final int w = 300;
    private static final int v = 200;
    private static BitMatrix Apw;
    private static BitMatrix Apz;
    private int[] stream;
    private int[] substream;
    private static int[] curr_stream;
    private static boolean initialised;
    private int[] state;
    private int state_i;

    private static void initialisation() {
        curr_stream = new int[]{-1779282517, 191386133, -412300569, -1354841543, 1902095651, 614830253, 1776596463, -1085972159, -1766057093, -1480722395, -1042385481, -2007455287, 766015123, -1235748387, -2323825, -2128487823, -1954398517, -2007169547, 1310772551, 1520096729, 1361841155, -360350515, 1287770895, -2003720031, -1497912613};
        try {
            InputStream inputStream = GenF2w32.class.getClassLoader().getResourceAsStream("umontreal/iro/lecuyer/rng/GenF2w32.dat");
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            Apw = (BitMatrix)objectInputStream.readObject();
            Apz = (BitMatrix)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Couldn't find GenF2w32.dat");
            fileNotFoundException.printStackTrace();
            System.exit(1);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(1);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            System.exit(1);
        }
        initialised = true;
    }

    private static int multiplyZ(int n, int n2, int n3) {
        for (int i = 0; i < n2; ++i) {
            if ((n & 1) != 0) {
                n = n >>> 1 ^ n3;
                continue;
            }
            n >>>= 1;
        }
        return n;
    }

    private static int multiply(int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 1;
        for (int i = 0; i < 32; ++i) {
            if ((n2 & n5) != 0) {
                n4 ^= GenF2w32.multiplyZ(n, 31 - i, n3);
            }
            n5 <<= 1;
        }
        return n4;
    }

    private static void initTables() {
        int n;
        BrmT1 = new int[2048];
        Br1 = new int[2048];
        BrmT2 = new int[2048];
        Br2 = new int[2048];
        BrmT3 = new int[1024];
        Br3 = new int[1024];
        for (n = 0; n < Br1.length; ++n) {
            GenF2w32.BrmT1[n] = GenF2w32.multiply(-425292512, n << 21, -95446209);
            GenF2w32.Br1[n] = GenF2w32.multiply(679131202, n << 21, -95446209);
        }
        for (n = 0; n < Br2.length; ++n) {
            GenF2w32.BrmT2[n] = GenF2w32.multiply(-425292512, n << 10, -95446209);
            GenF2w32.Br2[n] = GenF2w32.multiply(679131202, n << 10, -95446209);
        }
        for (n = 0; n < Br3.length; ++n) {
            GenF2w32.BrmT3[n] = GenF2w32.multiply(-425292512, n, -95446209);
            GenF2w32.Br3[n] = GenF2w32.multiply(679131202, n, -95446209);
        }
    }

    private void advanceSeed(int[] nArray, BitMatrix bitMatrix) {
        BitVector bitVector = new BitVector(nArray, 800);
        bitVector = bitMatrix.multiply(bitVector);
        for (int i = 0; i < 25; ++i) {
            nArray[i] = bitVector.getInt(i);
        }
    }

    private GenF2w32(int n) {
        this.state = new int[25];
        for (int i = 0; i < 25; ++i) {
            this.state[i] = 0;
        }
        this.state[n / 32] = 1 << n % 32;
        this.state_i = 24;
    }

    public GenF2w32() {
        if (!initialised) {
            GenF2w32.initialisation();
        }
        this.stream = new int[25];
        this.substream = new int[25];
        this.state = new int[25];
        for (int i = 0; i < 25; ++i) {
            this.stream[i] = curr_stream[i];
        }
        this.advanceSeed(curr_stream, Apz);
        this.resetStartStream();
    }

    public GenF2w32(String string) {
        this();
        this.name = string;
    }

    public static void setPackageSeed(int[] nArray) {
        int n;
        if (nArray.length != 25) {
            throw new IllegalArgumentException("Seed must contain 25values.");
        }
        boolean bl = false;
        for (n = 0; n < 25; ++n) {
            if (nArray[n] == 0) continue;
            bl = true;
        }
        if (!bl) {
            throw new IllegalArgumentException("At least one part of the seed must be non-zero.");
        }
        for (n = 0; n < 25; ++n) {
            GenF2w32.curr_stream[n] = nArray[n];
        }
    }

    public void setSeed(int[] nArray) {
        int n;
        if (nArray.length != 25) {
            throw new IllegalArgumentException("Seed must contain 25values.");
        }
        boolean bl = false;
        for (n = 0; n < 25; ++n) {
            if (nArray[n] == 0) continue;
            bl = true;
        }
        if (!bl) {
            throw new IllegalArgumentException("At least one part of the seed must be non-zero.");
        }
        for (n = 0; n < 25; ++n) {
            this.stream[n] = nArray[n];
        }
        this.resetStartStream();
    }

    public int[] getState() {
        int[] nArray = new int[25];
        for (int i = 0; i < 25; ++i) {
            nArray[i] = this.state[(this.state_i + i) % 25];
        }
        return nArray;
    }

    public GenF2w32 clone() {
        GenF2w32 genF2w32 = null;
        genF2w32 = (GenF2w32)super.clone();
        genF2w32.state = new int[25];
        genF2w32.substream = new int[25];
        genF2w32.stream = new int[25];
        for (int i = 0; i < 25; ++i) {
            genF2w32.state[i] = this.state[i];
            genF2w32.substream[i] = this.substream[i];
            genF2w32.stream[i] = this.stream[i];
        }
        return genF2w32;
    }

    public void resetStartStream() {
        for (int i = 0; i < 25; ++i) {
            this.substream[i] = this.stream[i];
        }
        this.resetStartSubstream();
    }

    public void resetStartSubstream() {
        this.state_i = 24;
        for (int i = 0; i < 25; ++i) {
            this.state[i] = this.substream[i];
        }
    }

    public void resetNextSubstream() {
        this.advanceSeed(this.substream, Apw);
        this.resetStartSubstream();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("The state of the ");
        stringBuffer.append(this.name == null ? "GenF2w32" : this.name);
        stringBuffer.append(" is : {");
        for (int i = 0; i < 24; ++i) {
            stringBuffer.append(this.state[(this.state_i + i) % 25] + ", ");
        }
        stringBuffer.append(this.state[(this.state_i + 25 - 1) % 25] + "}");
        return stringBuffer.toString();
    }

    protected double nextValue() {
        if (this.state_i < 0) {
            this.state_i = 24;
        }
        if (this.state_i + 7 < 25) {
            int n = this.state_i + 7;
            this.state[n] = this.state[n] ^ (BrmT1[(this.state[this.state_i] & 0xFFE00000) >>> 21] ^ BrmT2[(this.state[this.state_i] & 0x1FFC00) >>> 10] ^ BrmT3[this.state[this.state_i] & 0x3FF]);
        } else {
            int n = this.state_i + 7 - 25;
            this.state[n] = this.state[n] ^ (BrmT1[(this.state[this.state_i] & 0xFFE00000) >>> 21] ^ BrmT2[(this.state[this.state_i] & 0x1FFC00) >>> 10] ^ BrmT3[this.state[this.state_i] & 0x3FF]);
        }
        this.state[this.state_i] = Br1[(this.state[this.state_i] & 0xFFE00000) >>> 21] ^ Br2[(this.state[this.state_i] & 0x1FFC00) >>> 10] ^ Br3[this.state[this.state_i] & 0x3FF];
        long l = this.state[this.state_i--];
        return (double)(l <= 0L ? l + 0x100000000L : l) * 2.3283064359965952E-10;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.err.println("Must provide the output file.");
            System.exit(1);
        }
        System.out.println("Creating the GenF2w32 state transition matrices.");
        BitVector[] bitVectorArray = new BitVector[800];
        int[] nArray = new int[25];
        for (int i = 0; i < 800; ++i) {
            GenF2w32 genF2w32 = new GenF2w32(i);
            genF2w32.nextValue();
            for (int j = 0; j < 25; ++j) {
                nArray[j] = genF2w32.state[(j + 25 - 1) % 25];
            }
            bitVectorArray[i] = new BitVector(nArray, 800);
        }
        BitMatrix bitMatrix = new BitMatrix(bitVectorArray).transpose();
        BitMatrix bitMatrix2 = bitMatrix.power2e(300);
        BitMatrix bitMatrix3 = bitMatrix2.power2e(200);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(stringArray[0]);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(bitMatrix2);
            objectOutputStream.writeObject(bitMatrix3);
            objectOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Couldn't create " + stringArray[0]);
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    static {
        initialised = false;
        GenF2w32.initTables();
    }
}

