/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvar;

import umontreal.iro.lecuyer.probdist.ChiDist;
import umontreal.iro.lecuyer.randvar.ChiGen;
import umontreal.iro.lecuyer.rng.RandomStream;

public class ChiRatioOfUniformsGen
extends ChiGen {
    private int nu;

    public ChiRatioOfUniformsGen(RandomStream randomStream, ChiDist chiDist) {
        super(randomStream, chiDist);
        this.nu = chiDist.getNu();
    }

    public double nextDouble() {
        return ChiRatioOfUniformsGen.ratioOfUniforms(this.stream, this.nu);
    }

    public static double nextDouble(RandomStream randomStream, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("nu <= 0");
        }
        return ChiRatioOfUniformsGen.ratioOfUniforms(randomStream, n);
    }

    private static double ratioOfUniforms(RandomStream randomStream, int n) {
        double d;
        block7: {
            if (n == 1) {
                while (true) {
                    double d2 = randomStream.nextDouble();
                    double d3 = randomStream.nextDouble() * 0.857763884960707;
                    d = d3 / d2;
                    if (d < 0.0) continue;
                    double d4 = d * d;
                    double d5 = 2.5 - d4;
                    if (d < 0.0) {
                        d5 += d4 * d / (3.0 * d);
                    }
                    if (d2 < d5 * 0.3894003915 || !(d4 > 1.036961043 / d2 + 1.4) && 2.0 * Math.log(d2) < -d4 * 0.5) break;
                }
            } else {
                double d6;
                double d7 = Math.sqrt((double)n - 1.0);
                double d8 = -d7 > (d6 = -0.6065306597 * (1.0 - 0.25 / (d7 * d7 + 1.0))) ? -d7 : d6;
                double d9 = 0.6065306597 * (0.7071067812 + d7) / (0.5 + d7);
                double d10 = d9 - d8;
                while (true) {
                    double d11 = randomStream.nextDouble();
                    double d12 = randomStream.nextDouble() * d10 + d8;
                    d = d12 / d11;
                    if (d < -d7) continue;
                    double d13 = d * d;
                    double d14 = 2.5 - d13;
                    if (d < 0.0) {
                        d14 += d13 * d / (3.0 * (d + d7));
                    }
                    if (d11 < d14 * 0.3894003915) {
                        d += d7;
                        break block7;
                    }
                    if (!(d13 > 1.036961043 / d11 + 1.4) && 2.0 * Math.log(d11) < Math.log(1.0 + d / d7) * d7 * d7 - d13 * 0.5 - d * d7) break;
                }
                d += d7;
            }
        }
        return d;
    }
}

