/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.functions.MathFunction;
import umontreal.iro.lecuyer.probdist.ContinuousDistribution;
import umontreal.iro.lecuyer.probdist.ExponentialDist;
import umontreal.iro.lecuyer.probdist.NormalDist;
import umontreal.iro.lecuyer.util.Num;
import umontreal.iro.lecuyer.util.RootFinder;

public class GammaDist
extends ContinuousDistribution {
    private double alpha;
    private double lambda;
    private double logFactor;

    public GammaDist(double d) {
        this.setParams(d, 1.0, this.decPrec);
    }

    public GammaDist(double d, double d2) {
        this.setParams(d, d2, this.decPrec);
    }

    public GammaDist(double d, double d2, int n) {
        this.setParams(d, d2, n);
    }

    static double belog(double d) {
        double d2;
        if (d > 1.0) {
            return -GammaDist.belog(1.0 / d);
        }
        if (d < 1.0E-20) {
            return 1.0;
        }
        if (d < 0.9) {
            return (1.0 - d * d + 2.0 * d * Math.log(d)) / ((1.0 - d) * (1.0 - d));
        }
        if (d == 1.0) {
            return 0.0;
        }
        double d3 = 1.0 - d;
        double d4 = 1.0;
        double d5 = 0.0;
        int n = 2;
        do {
            d2 = (d4 *= d3) / (double)(n * (n + 1));
            ++n;
        } while (Math.abs(d2 / (d5 += d2)) > 1.0E-12);
        return 2.0 * d5;
    }

    public double density(double d) {
        if (d <= 0.0) {
            return 0.0;
        }
        double d2 = this.logFactor + (this.alpha - 1.0) * Math.log(d) - this.lambda * d;
        if (d2 > -1000.0) {
            return Math.exp(d2);
        }
        return 0.0;
    }

    public double cdf(double d) {
        return GammaDist.cdf(this.alpha, this.lambda, this.decPrec, d);
    }

    public double inverseF(double d) {
        return GammaDist.inverseF(this.alpha, this.decPrec, d) / this.lambda;
    }

    public double getMean() {
        return GammaDist.getMean(this.alpha, this.lambda);
    }

    public double getVariance() {
        return GammaDist.getVariance(this.alpha, this.lambda);
    }

    public double getStandardDeviation() {
        return GammaDist.getStandardDeviation(this.alpha, this.lambda);
    }

    public static double density(double d, double d2, double d3) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (d3 <= 0.0) {
            return 0.0;
        }
        double d4 = d * Math.log(d2 * d3) - d2 * d3 - Num.lnGamma(d);
        if (d4 > -1000.0) {
            return Math.exp(d4) / d3;
        }
        return 0.0;
    }

    public static double cdf(double d, double d2, int n, double d3) {
        return GammaDist.cdf(d, n, d2 * d3);
    }

    public static double cdf(double d, int n, double d2) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("d <= 0");
        }
        if (d2 <= 0.0) {
            return 0.0;
        }
        if (1.0 == d) {
            return ExponentialDist.cdf(1.0, d2);
        }
        if (d >= 100000.0) {
            double d3 = d2 + 0.3333333333333333 - d - 0.02 / d;
            double d4 = d - 0.5;
            double d5 = d3 * Math.sqrt((1.0 + GammaDist.belog(d4 / d2)) / d2);
            return NormalDist.cdf01(d5);
        }
        if (d2 <= 1.0 || d2 < d) {
            double d6 = Math.exp(d * Math.log(d2) - d2 - Num.lnGamma(d));
            double d7 = EPSARRAY[n];
            double d8 = 1.0;
            double d9 = 1.0;
            double d10 = d;
            while ((d9 *= d2 / (d10 += 1.0)) >= d7 * (d8 += d9)) {
            }
            return d8 * d6 / d;
        }
        return 1.0 - GammaDist.barF(d, n, d2);
    }

    public static double barF(double d, double d2, int n, double d3) {
        return GammaDist.barF(d, n, d2 * d3);
    }

    /*
     * Unable to fully structure code
     */
    public static double barF(double var0, int var2_1, double var3_2) {
        if (var0 <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (var2_1 <= 0) {
            throw new IllegalArgumentException("d <= 0");
        }
        if (var3_2 <= 0.0) {
            return 1.0;
        }
        if (1.0 == var0) {
            return ExponentialDist.barF(1.0, var3_2);
        }
        if (var3_2 >= var0 * 100.0 && var0 > 1.0) {
            return 0.0;
        }
        if (var0 >= 100000.0) {
            var7_3 = var3_2 + 0.3333333333333333 - var0 - 0.02 / var0;
            var9_5 = var0 - 0.5;
            var11_6 = var7_3 * Math.sqrt((1.0 + GammaDist.belog(var9_5 / var3_2)) / var3_2);
            return NormalDist.barF01(var11_6);
        }
        if (var3_2 <= 1.0 || var3_2 < var0) {
            return 1.0 - GammaDist.cdf(var0, var2_1, var3_2);
        }
        var7_4 = new double[6];
        var8_7 = GammaDist.EPSARRAY[var2_1];
        var12_8 = Math.exp(var0 * Math.log(var3_2) - var3_2 - Num.lnGamma(var0));
        var16_9 = 1.0 - var0;
        var18_10 = var16_9 + var3_2 + 1.0;
        var22_11 = 0.0;
        var7_4[0] = 1.0;
        var7_4[1] = var3_2;
        var7_4[2] = var3_2 + 1.0;
        var7_4[3] = var3_2 * var18_10;
        var14_12 = var7_4[2] / var7_4[3];
        block0: while (true) {
            var7_4[4] = (var18_10 += 2.0) * var7_4[2] - (var16_9 += 1.0) * (var22_11 += 1.0) * var7_4[0];
            var7_4[5] = var18_10 * var7_4[3] - var16_9 * var22_11 * var7_4[1];
            if (var7_4[5] != 0.0) {
                var20_13 = var7_4[4] / var7_4[5];
                var24_14 = Math.abs(var14_12 - var20_13);
                if (var24_14 <= var8_7 * var20_13) {
                    return var12_8 * var14_12;
                }
                var14_12 = var20_13;
            }
            for (var26_15 = 0; var26_15 < 4; ++var26_15) {
                var7_4[var26_15] = var7_4[var26_15 + 2];
            }
            if (!(Math.abs(var7_4[4]) >= 1.0E30)) continue;
            var26_15 = 0;
            while (true) {
                if (var26_15 < 4) ** break;
                continue block0;
                v0 = var26_15++;
                var7_4[v0] = var7_4[v0] / 1.0E30;
            }
            break;
        }
    }

    public static double inverseF(double d, double d2, int n, double d3) {
        return GammaDist.inverseF(d, n, d3) / d2;
    }

    public static double inverseF(double d, int n, double d2) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("d <= 0");
        }
        if (d2 > 1.0 || d2 < 0.0) {
            throw new IllegalArgumentException("u not in [0,1]");
        }
        if (d2 <= 0.0) {
            return 0.0;
        }
        if (d2 >= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        d2 = 1.0 - d2;
        double d3 = Double.MAX_VALUE;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 1.0;
        double d7 = 5.551115123125783E-16;
        double d8 = 1.0 / (9.0 * d);
        double d9 = 1.0 - d8 - NormalDist.inverseF01(d2) * Math.sqrt(d8);
        double d10 = d * d9 * d9 * d9;
        double d11 = Num.lnGamma(d);
        boolean bl = false;
        block0: while (true) {
            int n2;
            if (bl) {
                bl = false;
                d8 = 0.0625;
                if (d3 == Double.MAX_VALUE) {
                    if (d10 <= 0.0) {
                        d10 = 1.0;
                    }
                    while (d3 == Double.MAX_VALUE) {
                        d9 = GammaDist.barF(d, n, d10 = (1.0 + d8) * d10);
                        if (d9 < d2) {
                            d3 = d10;
                            d4 = d9;
                            break;
                        }
                        d8 += d8;
                    }
                }
                d8 = 0.5;
                int n3 = 0;
                for (n2 = 0; n2 < 400; ++n2) {
                    d10 = d5 + d8 * (d3 - d5);
                    d9 = GammaDist.barF(d, n, d10);
                    d11 = (d3 - d5) / (d5 + d3);
                    if (Math.abs(d11) < d7 || Math.abs(d11 = (d9 - d2) / d2) < d7 || d10 <= 0.0) break;
                    if (d9 >= d2) {
                        d5 = d10;
                        d6 = d9;
                        if (n3 < 0) {
                            n3 = 0;
                            d8 = 0.5;
                        } else {
                            d8 = n3 > 1 ? 0.5 * d8 + 0.5 : (d2 - d4) / (d6 - d4);
                        }
                        ++n3;
                        continue;
                    }
                    d3 = d10;
                    d4 = d9;
                    if (n3 > 0) {
                        n3 = 0;
                        d8 = 0.5;
                    } else {
                        d8 = n3 < -1 ? 0.5 * d8 : (d2 - d4) / (d6 - d4);
                    }
                    --n3;
                }
                if (d10 == 0.0) {
                    System.err.println("GammaDist.inverseF: underflow");
                }
                return d10;
            }
            for (n2 = 0; n2 < 13; ++n2) {
                if (d10 > d3 || d10 < d5) {
                    bl = true;
                    continue block0;
                }
                d9 = GammaDist.barF(d, n, d10);
                if (d9 < d4 || d9 > d6) {
                    bl = true;
                    continue block0;
                }
                if (d9 < d2) {
                    d3 = d10;
                    d4 = d9;
                } else {
                    d5 = d10;
                    d6 = d9;
                }
                d8 = (d - 1.0) * Math.log(d10) - d10 - d11;
                if (d8 < -709.782712893384) {
                    bl = true;
                    continue block0;
                }
                d8 = -Math.exp(d8);
                if (Math.abs((d8 = (d9 - d2) / d8) / d10) < (double)1.110223E-16f) {
                    return d10;
                }
                d10 -= d8;
            }
            break;
        }
        return d10;
    }

    public static double[] getMLE(double[] dArray, int n) {
        double d;
        int n2;
        double d2 = 0.0;
        double d3 = 0.0;
        double[] dArray2 = new double[2];
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        for (n2 = 0; n2 < n; ++n2) {
            d2 += dArray[n2];
            if (dArray[n2] <= 0.0) {
                d3 += -709.089565712824;
                continue;
            }
            d3 += Math.log(dArray[n2]);
        }
        double d4 = d2 / (double)n;
        d2 = 0.0;
        for (n2 = 0; n2 < n; ++n2) {
            d2 += (dArray[n2] - d4) * (dArray[n2] - d4);
        }
        double d5 = d4 * d4 * (double)n / d2;
        double d6 = d5 - 1.0;
        if (d <= 0.0) {
            d6 = 1.0E-5;
        }
        Function function = new Function(n, d4, d3);
        dArray2[0] = RootFinder.brentDekker(d6, d5 + 1.0, function, 1.0E-7);
        dArray2[1] = dArray2[0] / d4;
        return dArray2;
    }

    public static double[] getMaximumLikelihoodEstimate(double[] dArray, int n) {
        return GammaDist.getMLE(dArray, n);
    }

    public static GammaDist getInstanceFromMLE(double[] dArray, int n) {
        double[] dArray2 = GammaDist.getMaximumLikelihoodEstimate(dArray, n);
        return new GammaDist(dArray2[0], dArray2[1]);
    }

    public static double getMean(double d, double d2) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        return d / d2;
    }

    public static double getVariance(double d, double d2) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        return d / (d2 * d2);
    }

    public static double getStandardDeviation(double d, double d2) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        return Math.sqrt(d) / d2;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getLambda() {
        return this.lambda;
    }

    public void setParams(double d, double d2, int n) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        this.alpha = d;
        this.lambda = d2;
        this.decPrec = n;
        this.logFactor = d * Math.log(d2) - Num.lnGamma(d);
        this.supportA = 0.0;
    }

    public double[] getParams() {
        double[] dArray = new double[]{this.alpha, this.lambda};
        return dArray;
    }

    public String toString() {
        return this.getClass().getName() + " : alpha = " + this.alpha + ", lambda = " + this.lambda;
    }

    private static class Function
    implements MathFunction {
        private int n;
        private double empiricalMean;
        private double sumLn;

        public Function(int n, double d, double d2) {
            this.n = n;
            this.empiricalMean = d;
            this.sumLn = d2;
        }

        public double evaluate(double d) {
            if (d <= 0.0) {
                return 1.0E200;
            }
            return (double)this.n * Math.log(this.empiricalMean / d) + (double)this.n * Num.digamma(d) - this.sumLn;
        }
    }
}

