/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.hups;

import umontreal.iro.lecuyer.hups.Rank1Lattice;

public class KorobovLattice
extends Rank1Lattice {
    protected int a;

    public KorobovLattice(int n, int n2, int n3) {
        super(n, null, 0);
        if (n2 <= 1 || n2 >= n) {
            throw new IllegalArgumentException("KorobovLattice must have 1 < a < n");
        }
        this.a = n2;
        this.dim = n3;
        this.v = new double[n3];
        long[] lArray = new long[this.dim];
        lArray[0] = 1L;
        this.v[0] = this.normFactor;
        for (int i = 1; i < this.dim; ++i) {
            lArray[i] = (long)n2 * lArray[i - 1] % (long)n;
            this.v[i] = this.normFactor * (double)lArray[i];
        }
    }

    public KorobovLattice(int n, int n2, int n3, int n4) {
        super(n, null, 0);
        int n5;
        if (n2 <= 1 || n2 >= n) {
            throw new IllegalArgumentException("KorobovLattice must have 1 < a < n");
        }
        if (n4 < 1) {
            throw new IllegalArgumentException("KorobovLattice: must have 0 < t");
        }
        this.a = n2;
        this.dim = n3;
        this.v = new double[n3];
        long[] lArray = new long[this.dim];
        lArray[0] = n2;
        for (n5 = 1; n5 < n4; ++n5) {
            lArray[0] = lArray[0] * (long)n2;
        }
        this.v[0] = (double)lArray[0] * this.normFactor;
        for (n5 = 1; n5 < this.dim; ++n5) {
            lArray[n5] = (long)n2 * lArray[n5 - 1] % (long)n;
            this.v[n5] = this.normFactor * (double)lArray[n5];
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("KorobovLattice:\n");
        stringBuffer.append("Multiplier a: " + this.a + "\n");
        stringBuffer.append(super.toString());
        return stringBuffer.toString();
    }
}

