/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.hups;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;

public class F2wStructure {
    private final int ALLONES = Integer.MAX_VALUE;
    int w;
    int r;
    int numBits;
    private int modQ;
    private int step;
    private int[] coeff;
    private int[] nocoeff;
    private int nbcoeff;
    int S;
    private int maskw;
    private int maskrw;
    private int maskZrm1;
    private int mask31;
    private int t;
    private int masktrw;
    private int[] maskv;
    int state;
    int output;
    double normFactor;
    static final int MBL = 140;

    private void init(int n, int n2, int n3, int n4, int n5, int[] nArray, int[] nArray2) {
        this.normFactor = 4.656612873077393E-10;
        this.numBits = 31;
        this.step = n4;
        this.w = n;
        this.r = n2;
        this.S = 31 - n2 * n;
        this.mask31 = Integer.MAX_VALUE;
        this.maskw = (1 << n) - 1;
        this.maskrw = (1 << n2 * n) - 1 << this.S;
        this.maskZrm1 = Integer.MAX_VALUE >> n2 * n ^ Integer.MAX_VALUE >> (n2 - 1) * n;
        this.modQ = n3;
        this.nbcoeff = n5;
        this.nocoeff = new int[n5];
        this.coeff = new int[n5];
        for (int i = 0; i < n5; ++i) {
            this.nocoeff[i] = nArray2[i];
            this.coeff[i] = nArray[i];
        }
    }

    void initParamLFSR() {
        this.t = (31 - this.r * this.w) / this.w;
        this.masktrw = -1 << 31 - (this.t + this.r) * this.w & this.mask31;
        this.maskv = new int[this.r];
        for (int i = 0; i < this.r; ++i) {
            this.maskv[i] = this.maskw << this.S + (this.r - 1 - i) * this.w;
        }
    }

    F2wStructure(int n, int n2, int n3, int n4, int n5, int[] nArray, int[] nArray2) {
        this.init(n, n2, n3, n4, n5, nArray, nArray2);
    }

    F2wStructure(String string, int n) {
        try {
            BufferedReader bufferedReader;
            if (new File(string).exists()) {
                bufferedReader = new BufferedReader(new FileReader(string));
            } else {
                DataInputStream dataInputStream = new DataInputStream(F2wStructure.class.getClassLoader().getResourceAsStream("umontreal/iro/lecuyer/hups/dataF2w/" + string));
                bufferedReader = new BufferedReader(new InputStreamReader(dataInputStream));
            }
            this.initFromReader(string, bufferedReader, n);
            bufferedReader.close();
        }
        catch (Exception exception) {
            System.out.println("IO Error: problems finding file " + string);
            System.exit(1);
        }
    }

    private int multiplyz(int n, int n2) {
        if (n2 == 0) {
            return n & this.maskw;
        }
        for (int i = 0; i < n2; ++i) {
            if ((1 & n) == 1) {
                n = n >> 1 ^ this.modQ;
                continue;
            }
            n >>= 1;
        }
        return n & this.maskw;
    }

    int getLog2N() {
        return this.r * this.w;
    }

    int multiply(int n, int n2) {
        int n3 = 0;
        int n4 = 1;
        for (int i = 0; i < this.w; ++i) {
            if ((n2 & n4) == n4) {
                n3 ^= this.multiplyz(n, this.w - 1 - i);
            }
            n4 <<= 1;
        }
        return n3 & this.maskw;
    }

    void initF2wLFSR() {
        int n;
        int n2 = 0;
        this.output = n = this.state << this.S;
        for (int i = 1; i <= this.t; ++i) {
            n2 = 0;
            for (int j = 0; j < this.nbcoeff; ++j) {
                int n3 = (n & this.maskv[this.nocoeff[j]]) >> this.S + (this.r - 1 - this.nocoeff[j]) * this.w;
                n2 ^= this.multiply(this.coeff[j], n3);
            }
            this.output |= n2 << this.S - i * this.w;
            n = this.output << i * this.w & this.maskrw;
        }
    }

    void F2wLFSR() {
        int n = 0;
        for (int i = 0; i < this.step; ++i) {
            int n2 = this.output << this.t * this.w & this.maskrw;
            n = 0;
            for (int j = 0; j < this.nbcoeff; ++j) {
                int n3 = (n2 & this.maskv[this.nocoeff[j]]) >> this.S + (this.r - 1 - this.nocoeff[j]) * this.w;
                n ^= this.multiply(this.coeff[j], n3);
            }
            this.output = this.output << this.w & this.masktrw | n << 31 - (this.r + this.t) * this.w;
        }
        this.state = (this.output & this.maskrw) >> this.S;
    }

    int F2wPolyLCG() {
        for (int i = 0; i < this.step; ++i) {
            int n = (this.state & this.maskZrm1) >> this.S;
            this.state = this.state >> this.w & this.maskrw;
            for (int j = 0; j < this.nbcoeff; ++j) {
                this.state ^= this.multiply(this.coeff[j], n) << this.S + (this.r - 1 - this.nocoeff[j]) * this.w;
            }
        }
        return this.state;
    }

    public static void print(String string) {
        try {
            Object object;
            BufferedReader bufferedReader;
            if (new File(string).exists()) {
                bufferedReader = new BufferedReader(new FileReader(string));
            } else {
                object = new DataInputStream(F2wStructure.class.getClassLoader().getResourceAsStream("umontreal/iro/lecuyer/hups/dataF2w/" + string));
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object));
            }
            for (int i = 0; i < 4; ++i) {
                bufferedReader.readLine();
            }
            while ((object = bufferedReader.readLine()) != null) {
                System.out.println((String)object);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            System.out.println("IO Error: problems reading file " + string);
            System.exit(1);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("z^");
        stringBuffer.append(this.r);
        for (int i = this.nbcoeff - 1; i >= 0; --i) {
            stringBuffer.append(" + (" + this.coeff[i] + ") z^" + this.nocoeff[i]);
        }
        stringBuffer.append("   modQ = " + this.modQ + "    w = " + this.w + "   step = " + this.step);
        return stringBuffer.toString();
    }

    private void initFromReader(String string, BufferedReader bufferedReader, int n) {
        int n2 = n + 4;
        try {
            int n3;
            for (n3 = 1; n3 < n2; ++n3) {
                bufferedReader.readLine();
            }
            StringTokenizer stringTokenizer = new StringTokenizer(bufferedReader.readLine());
            int n4 = Integer.parseInt(stringTokenizer.nextToken());
            int n5 = Integer.parseInt(stringTokenizer.nextToken());
            int n6 = Integer.parseInt(stringTokenizer.nextToken());
            int n7 = Integer.parseInt(stringTokenizer.nextToken());
            int n8 = Integer.parseInt(stringTokenizer.nextToken());
            int[] nArray = new int[n8];
            int[] nArray2 = new int[n8];
            for (n3 = 0; n3 < n8; ++n3) {
                nArray2[n3] = Integer.parseInt(stringTokenizer.nextToken());
                nArray[n3] = Integer.parseInt(stringTokenizer.nextToken());
            }
            this.init(n4, n5, n6, n7, n8, nArray2, nArray);
            bufferedReader.close();
        }
        catch (Exception exception) {
            System.out.println("Input Error: problems reading file " + string);
            System.exit(1);
        }
    }
}

