/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.coalescent;

import dr.evolution.coalescent.DemographicFunction;
import dr.evolution.util.Units;

public class EmpiricalPiecewiseConstant
extends DemographicFunction.Abstract {
    double[] intervals;
    double[] popSizes;
    double lag;

    public EmpiricalPiecewiseConstant(double[] dArray, double[] dArray2, double d, Units.Type type) {
        super(type);
        if (dArray2 == null || dArray == null) {
            throw new IllegalArgumentException();
        }
        if (dArray2.length != dArray.length + 1) {
            throw new IllegalArgumentException();
        }
        if (d < 0.0) {
            throw new IllegalArgumentException("Lag must be greater than 1.");
        }
        this.intervals = dArray;
        this.popSizes = dArray2;
        this.lag = d;
    }

    public void setLag(double d) {
        this.lag = d;
    }

    public void setPopulationSizes(double[] dArray) {
        this.popSizes = dArray;
    }

    @Override
    public double getDemographic(double d) {
        int n = 0;
        double d2 = d + this.lag;
        while (d2 > this.getEpochDuration(n)) {
            d2 -= this.getEpochDuration(n);
            ++n;
        }
        return this.getDemographic(n, d2);
    }

    @Override
    public double getIntensity(double d) {
        double d2 = this.lag;
        int n = 0;
        while (d2 > this.getEpochDuration(n)) {
            d2 -= this.getEpochDuration(n);
            ++n;
        }
        double d3 = this.getIntensity(n) - this.getIntensity(n, d2);
        double d4 = d - (this.getEpochDuration(n) - d2);
        ++n;
        while (d4 > this.getEpochDuration(n)) {
            d4 -= this.getEpochDuration(n);
            d3 += this.getIntensity(n);
            ++n;
        }
        return d3 += d4 >= 0.0 ? this.getIntensity(n, d4) : this.getIntensity(n - 1, d4);
    }

    @Override
    public double getInverseIntensity(double d) {
        throw new RuntimeException("Not implemented!");
    }

    @Override
    public double getUpperBound(int n) {
        return 1.0E9;
    }

    @Override
    public double getLowerBound(int n) {
        return Double.MIN_VALUE;
    }

    @Override
    public int getNumArguments() {
        return 1;
    }

    @Override
    public String getArgumentName(int n) {
        return "lag";
    }

    @Override
    public double getArgument(int n) {
        return this.lag;
    }

    @Override
    public void setArgument(int n, double d) {
        this.lag = d;
    }

    public DemographicFunction getCopy() {
        EmpiricalPiecewiseConstant empiricalPiecewiseConstant = new EmpiricalPiecewiseConstant(new double[this.intervals.length], new double[this.popSizes.length], this.lag, this.getUnits());
        System.arraycopy(this.intervals, 0, empiricalPiecewiseConstant.intervals, 0, this.intervals.length);
        System.arraycopy(this.popSizes, 0, empiricalPiecewiseConstant.popSizes, 0, this.popSizes.length);
        return empiricalPiecewiseConstant;
    }

    protected double getDemographic(int n, double d) {
        return this.getEpochDemographic(n);
    }

    protected double getIntensity(int n) {
        return this.getEpochDuration(n) / this.getEpochDemographic(n);
    }

    protected double getIntensity(int n, double d) {
        return d / this.getEpochDemographic(n);
    }

    public double getEpochDuration(int n) {
        if (n < this.intervals.length) {
            return this.intervals[n];
        }
        return Double.POSITIVE_INFINITY;
    }

    public double getEpochDemographic(int n) {
        if (n >= this.popSizes.length) {
            throw new IllegalArgumentException();
        }
        return this.popSizes[n];
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.popSizes[0]);
        for (int i = 1; i < this.popSizes.length; ++i) {
            stringBuffer.append("\t").append(this.popSizes[i]);
        }
        return stringBuffer.toString();
    }
}

