/*
 * Decompiled with CFR 0.152.
 */
package auc;

import auc.Confusion;
import auc.ReadList;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class AUCCalculator {
    private static String fileName;
    private static String fileType;
    private static double posCount;
    private static double negCount;
    private static double minRecall;
    public static boolean DEBUG;

    static {
        minRecall = 0.0;
        DEBUG = false;
    }

    public static void main(String[] args) {
        AUCCalculator.readArgs(args);
        Confusion confusion = fileType.equalsIgnoreCase("list") ? ReadList.readFile(fileName, fileType) : AUCCalculator.readFile(fileName, fileType, posCount, negCount);
        confusion.writePRFile(fileName + ".pr");
        confusion.writeStandardPRFile(fileName + ".spr");
        confusion.writeROCFile(fileName + ".roc");
        confusion.calculateAUCPR(minRecall);
        confusion.calculateAUCROC();
    }

    public static void readArgs(String[] as) {
        fileName = "";
        int byte0 = 2;
        try {
            fileName = as[0];
            fileType = as[1];
            if (!(fileType.equalsIgnoreCase("PR") || fileType.equalsIgnoreCase("ROC") || fileType.equalsIgnoreCase("list"))) {
                throw new NoSuchElementException();
            }
            if (fileType.equalsIgnoreCase("PR") || fileType.equalsIgnoreCase("ROC")) {
                posCount = Double.parseDouble(as[2]);
                negCount = Double.parseDouble(as[3]);
                byte0 = 4;
                if (posCount < 1.0 || negCount < 1.0) {
                    throw new NumberFormatException();
                }
            }
        }
        catch (IndexOutOfBoundsException indexoutofboundsexception) {
            System.err.println("ERROR: Missing Arguments - exiting...");
            System.err.println("Usage:\njava AUCCalculator <fileName> <fileType> <posCount*> <negCount*> <minRecall**>");
            System.err.println("   posCount and negCount required if fileType ROC or PR");
            System.err.println("   minRecall always optional");
            System.exit(-1);
        }
        catch (NumberFormatException numberformatexception) {
            System.err.println("ERROR: Incorrect Count arguments, must be positive numbers - exiting...");
            System.err.println("Usage:\njava AUCCalculator <fileName> <posCount*> <negCount*> <minRecall**>");
            System.err.println("   posCount and negCount required if fileType ROC or PR");
            System.err.println("   minRecall always optional");
            System.exit(-1);
        }
        catch (NoSuchElementException nosuchelementexception) {
            System.err.println("ERROR: Incorrect fileType, must be ROC, PR, LIST - exiting...");
            System.err.println("Usage:\njava AUCCalculator <fileName> <posCount*> <negCount*> <minRecall**>");
            System.err.println("   posCount and negCount required if fileType ROC or PR");
            System.err.println("   minRecall always optional");
            System.exit(-1);
        }
        try {
            minRecall = Double.parseDouble(as[byte0]);
            if (minRecall < 0.0 || minRecall > 1.0) {
                throw new NumberFormatException();
            }
        }
        catch (IndexOutOfBoundsException nosuchelementexception) {
        }
        catch (NumberFormatException numberformatexception1) {
            System.err.println("ERROR: Incorrect minRecall argument, must be positive between 0 and 1 - exiting...");
            System.err.println("Usage:\njava AUCCalculator <fileName> <posCount*> <negCount*> <minRecall**>");
            System.err.println("   posCount and negCount required if fileType ROC or PR");
            System.err.println("   minRecall always optional");
            System.exit(-1);
        }
    }

    public static Confusion readFile(String s, String s1, double d, double d1) {
        if (DEBUG) {
            System.out.println("--- Reading in " + s1 + " File: " + s + " ---");
        }
        Confusion confusion = new Confusion(d, d1);
        try {
            BufferedReader bufferedreader = new BufferedReader(new FileReader(new File(s)));
            if (!(s1.equals("PR") || s1.equals("ROC") || s1.equals("pr") || s1.equals("roc"))) {
                bufferedreader.close();
                throw new NoSuchElementException();
            }
            while (bufferedreader.ready()) {
                String s2 = bufferedreader.readLine();
                if (DEBUG) {
                    System.out.println(s2);
                }
                StringTokenizer stringtokenizer = new StringTokenizer(s2, "\t ,");
                try {
                    double d2 = Double.parseDouble(stringtokenizer.nextToken());
                    double d3 = Double.parseDouble(stringtokenizer.nextToken());
                    if (DEBUG) {
                        System.out.println(d2 + "\t" + d3);
                    }
                    if (s1.equals("PR")) {
                        confusion.addPRPoint(d2, d3);
                    } else {
                        confusion.addROCPoint(d2, d3);
                    }
                    if (!DEBUG) continue;
                    System.out.println("End of Line");
                }
                catch (NumberFormatException numberformatexception) {
                    System.err.println("...skipping bad input line (bad numbers)");
                }
                catch (NoSuchElementException nosuchelementexception1) {
                    System.err.println("...skipping bad input line (missing data)");
                }
            }
            bufferedreader.close();
        }
        catch (FileNotFoundException filenotfoundexception) {
            System.err.println("ERROR: File " + s + " not found - exiting...");
            System.exit(-1);
        }
        catch (NoSuchElementException nosuchelementexception) {
            System.err.println("...incorrect fileType argument, either PR or ROC - exiting");
            System.exit(-1);
        }
        catch (IOException ioexception) {
            System.err.println("ERROR: IO Exception in file " + s + " - exiting...");
            System.exit(-1);
        }
        confusion.sort();
        confusion.interpolate();
        return confusion;
    }

    public static Confusion readArrays(int[] ai, double[] ad) {
        if (ai.length != ad.length || ai.length == 0) {
            System.err.println(ai.length + " " + ad.length);
            System.err.println("ERROR: incorrect array lengths - exiting");
            System.exit(-1);
        }
        double d = 0.0;
        double d1 = 0.0;
        int i = 0;
        while (i < ai.length) {
            if (ai[i] == 0) {
                d1 += 1.0;
            } else if (ai[i] == 1) {
                d += 1.0;
            } else {
                System.err.println("ERROR: example not 0 or 1 - exiting");
                System.exit(-1);
            }
            ++i;
        }
        Confusion confusion = new Confusion(d, d1);
        double d2 = 0.0;
        double d3 = 0.0;
        if (ai[0] == 0) {
            d3 += 1.0;
        } else if (ai[0] == 1) {
            d2 += 1.0;
        } else {
            System.err.println("ERROR: example not 0 or 1 - exiting");
            System.exit(-1);
        }
        int j = 1;
        while (j < ad.length) {
            if (ad[j] != ad[j - 1]) {
                try {
                    confusion.addPoint(d2, d3);
                }
                catch (NumberFormatException numberformatexception) {
                    System.err.println("...skipping bad input line (bad numbers)");
                }
            }
            if (ai[j] == 0) {
                d3 += 1.0;
            } else if (ai[j] == 1) {
                d2 += 1.0;
            } else {
                System.err.println("ERROR: example not 0 or 1 - exiting");
                System.exit(-1);
            }
            ++j;
        }
        confusion.addPoint(d2, d3);
        confusion.sort();
        confusion.interpolate();
        return confusion;
    }
}

