/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.rng;

import umontreal.iro.lecuyer.rng.RandomStream;
import umontreal.iro.lecuyer.rng.RandomStreamFactory;
import umontreal.iro.lecuyer.rng.RandomStreamInstantiationException;

public class BasicRandomStreamFactory
implements RandomStreamFactory {
    private Class rsClass;

    public BasicRandomStreamFactory(Class clazz) {
        this.checkRandomStreamClass(clazz);
        this.rsClass = clazz;
    }

    public Class getRandomStreamClass() {
        return this.rsClass;
    }

    public void setRandomStreamClass(Class clazz) {
        this.checkRandomStreamClass(clazz);
        this.rsClass = clazz;
    }

    private void checkRandomStreamClass(Class clazz) {
        if (!RandomStream.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("The random class must implement the RandomStream interface");
        }
        try {
            clazz.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException("The random stream class " + clazz.getName() + " does not have a " + "nullary public constructor.");
        }
    }

    public RandomStream newInstance() {
        try {
            return (RandomStream)this.rsClass.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RandomStreamInstantiationException(this, "Cannot access constructor for random stream class " + this.rsClass.getName(), illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new RandomStreamInstantiationException(this, "Cannot instantiate random stream class " + this.rsClass.getName(), instantiationException);
        }
        catch (Exception exception) {
            throw new RandomStreamInstantiationException(this, "Exception while calling the nullary constructor for random stream class " + this.rsClass.getName(), exception);
        }
    }

    public String toString() {
        return "Basic random stream factory constructing streams of class " + this.rsClass.getName();
    }
}

