/*
 * Decompiled with CFR 0.152.
 */
package dr.xml;

import dr.util.Attribute;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class AttributesParser
extends AbstractXMLObjectParser {
    public static final String ATTRIBUTES = "attributes";
    public static final String NAMES = "names";
    public static final String VALUES = "values";
    private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newStringArrayRule("names"), AttributeRule.newStringArrayRule("values")};

    @Override
    public String getParserName() {
        return ATTRIBUTES;
    }

    @Override
    public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
        String[] stringArray;
        String[] stringArray2 = xMLObject.getChild(NAMES).getStringArrayChild(0);
        if (stringArray2.length != (stringArray = xMLObject.getChild(VALUES).getStringArrayChild(0)).length) {
            throw new XMLParseException("The number of names and values must match.");
        }
        Attribute[] attributeArray = new Attribute[stringArray2.length];
        for (int i = 0; i < attributeArray.length; ++i) {
            attributeArray[i] = new Attribute.Default<String>(stringArray2[i], stringArray[i]);
        }
        return attributeArray;
    }

    @Override
    public String getParserDescription() {
        return "This element represents an array of name/value pairs.";
    }

    @Override
    public Class getReturnType() {
        return Attribute[].class;
    }

    @Override
    public XMLSyntaxRule[] getSyntaxRules() {
        return this.rules;
    }
}

