/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import dr.inference.distribution.DistributionLikelihood;
import dr.inference.model.CompoundLikelihood;
import dr.inference.model.Likelihood;
import dr.math.distributions.GaussianProcessRandomGenerator;
import dr.xml.Reportable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class CompoundGaussianProcess
implements GaussianProcessRandomGenerator,
Reportable {
    private final List<GaussianProcessRandomGenerator> gpList;
    private final List<Integer> copyList;
    private final List<Likelihood> likelihoodList;
    private final CompoundLikelihood compoundLikelihood;
    private final ExecutorService pool;
    private final int threadCount;
    private final List<Callable<DrawResult>> callers;
    private static final boolean USE_POOL = false;
    private int dimension = -1;

    public CompoundGaussianProcess(List<GaussianProcessRandomGenerator> list, List<Likelihood> list2, List<Integer> list3) {
        this.gpList = list;
        this.copyList = list3;
        this.likelihoodList = list2;
        this.compoundLikelihood = new CompoundLikelihood(list2);
        this.callers = null;
        this.threadCount = -1;
        this.pool = null;
    }

    public boolean contains(Likelihood likelihood) {
        return this.likelihoodList.contains(likelihood);
    }

    @Override
    public int getDimension() {
        if (this.dimension == -1) {
            this.dimension = 0;
            for (GaussianProcessRandomGenerator gaussianProcessRandomGenerator : this.gpList) {
                this.dimension += gaussianProcessRandomGenerator.getDimension();
            }
        }
        return this.dimension;
    }

    @Override
    public double[][] getPrecisionMatrix() {
        if (this.gpList.size() == 1) {
            return this.gpList.get(0).getPrecisionMatrix();
        }
        int n = this.getDimension();
        double[][] dArray = new double[n][n];
        int n2 = 0;
        for (GaussianProcessRandomGenerator gaussianProcessRandomGenerator : this.gpList) {
            int n3 = gaussianProcessRandomGenerator.getDimension();
            double[][] dArray2 = gaussianProcessRandomGenerator.getPrecisionMatrix();
            for (int i = 0; i < n3; ++i) {
                System.arraycopy(dArray2[i], 0, dArray[n2 + i], n2, n3);
            }
            n2 += n3;
        }
        return dArray;
    }

    @Override
    public Likelihood getLikelihood() {
        return this.compoundLikelihood;
    }

    @Override
    public String getReport() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("compoundGP: " + this.getLikelihood().getLogLikelihood());
        return stringBuilder.toString();
    }

    private List<Callable<DrawResult>> createTasks() {
        ArrayList<Callable<DrawResult>> arrayList = new ArrayList<Callable<DrawResult>>();
        int n = 0;
        int n2 = 0;
        for (GaussianProcessRandomGenerator gaussianProcessRandomGenerator : this.gpList) {
            int n3 = this.copyList.get(n2);
            if (this.likelihoodList.get(n2) instanceof DistributionLikelihood) {
                arrayList.add(new DrawCaller(gaussianProcessRandomGenerator, n3, n, true));
                n += n3;
                continue;
            }
            for (int i = 0; i < n3; ++i) {
                arrayList.add(new DrawCaller(gaussianProcessRandomGenerator, 1, n, false));
                n += gaussianProcessRandomGenerator.getDimension();
            }
        }
        return arrayList;
    }

    @Override
    public Object nextRandom() {
        return this.nextRandomSerial();
    }

    private Object nextRandomParallel() {
        double[] dArray = new double[this.getDimension()];
        try {
            List<Future<DrawResult>> list = this.pool.invokeAll(this.callers);
            for (Future<DrawResult> future : list) {
                DrawResult drawResult = future.get();
                System.arraycopy(drawResult.result, 0, dArray, drawResult.offset, drawResult.result.length);
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
        }
        return dArray;
    }

    private Object nextRandomSerial() {
        int n = 0;
        ArrayList<double[]> arrayList = new ArrayList<double[]>();
        int n2 = 0;
        for (GaussianProcessRandomGenerator gaussianProcessRandomGenerator : this.gpList) {
            int n3 = this.copyList.get(n2);
            if (this.likelihoodList.get(n2) instanceof DistributionLikelihood) {
                double[] dArray = new double[n3];
                for (int i = 0; i < n3; ++i) {
                    dArray[i] = (Double)gaussianProcessRandomGenerator.nextRandom();
                }
                arrayList.add(dArray);
                n += dArray.length;
            } else {
                for (int i = 0; i < this.copyList.get(n2); ++i) {
                    double[] dArray = (double[])gaussianProcessRandomGenerator.nextRandom();
                    arrayList.add(dArray);
                    n += dArray.length;
                }
            }
            ++n2;
        }
        Object object = new double[n];
        int n4 = 0;
        for (double[] dArray : arrayList) {
            System.arraycopy(dArray, 0, object, n4, dArray.length);
            n4 += dArray.length;
        }
        return object;
    }

    @Override
    public double logPdf(Object object) {
        throw new RuntimeException("Not yet implemented");
    }

    private class DrawCaller
    implements Callable<DrawResult> {
        private final GaussianProcessRandomGenerator gp;
        private final int copies;
        private final int offset;
        private final boolean isUnivariate;

        public DrawCaller(GaussianProcessRandomGenerator gaussianProcessRandomGenerator, int n, int n2, boolean bl) {
            this.gp = gaussianProcessRandomGenerator;
            this.copies = n;
            this.offset = n2;
            this.isUnivariate = bl;
        }

        @Override
        public DrawResult call() throws Exception {
            double[] dArray;
            if (this.isUnivariate) {
                dArray = new double[this.copies];
                for (int i = 0; i < this.copies; ++i) {
                    dArray[i] = (Double)this.gp.nextRandom();
                }
            } else {
                dArray = (double[])this.gp.nextRandom();
            }
            return new DrawResult(dArray, this.offset);
        }
    }

    private class DrawResult {
        final double[] result;
        final int offset;

        DrawResult(double[] dArray, int n) {
            this.result = dArray;
            this.offset = n;
        }
    }
}

