/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.distribution;

import dr.inference.distribution.DeterminentalPointProcessPrior;
import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.AdaptableSizeFastMatrixParameter;
import dr.inference.model.MatrixParameterInterface;
import dr.inference.model.MatrixSizePrior;
import dr.inference.model.Model;
import dr.inference.model.Variable;
import dr.math.distributions.PoissonDistribution;

public class RowDimensionPoissonPrior
extends AbstractModelLikelihood
implements MatrixSizePrior {
    PoissonDistribution poisson;
    MatrixParameterInterface parameter;
    boolean transpose;
    DeterminentalPointProcessPrior DPP;
    int[] count;
    int[] storedCount;

    public RowDimensionPoissonPrior(String string, double d, MatrixParameterInterface matrixParameterInterface, DeterminentalPointProcessPrior determinentalPointProcessPrior, boolean bl) {
        block7: {
            super(string);
            this.poisson = new PoissonDistribution(d);
            this.parameter = matrixParameterInterface;
            if (matrixParameterInterface != null) {
                this.addVariable(matrixParameterInterface);
            }
            this.transpose = bl;
            this.DPP = determinentalPointProcessPrior;
            if (matrixParameterInterface == null || matrixParameterInterface instanceof AdaptableSizeFastMatrixParameter) break block7;
            if (!bl) {
                this.count = new int[matrixParameterInterface.getColumnDimension()];
                this.storedCount = new int[matrixParameterInterface.getColumnDimension()];
                for (int i = 0; i < this.count.length; ++i) {
                    for (int j = 0; j < matrixParameterInterface.getRowDimension(); ++j) {
                        int n = i;
                        this.count[n] = (int)((double)this.count[n] + matrixParameterInterface.getParameterValue(j, i));
                    }
                }
            } else {
                this.count = new int[matrixParameterInterface.getRowDimension()];
                this.storedCount = new int[matrixParameterInterface.getRowDimension()];
                for (int i = 0; i < this.count.length; ++i) {
                    for (int j = 0; j < matrixParameterInterface.getColumnDimension(); ++j) {
                        int n = i;
                        this.count[n] = (int)((double)this.count[n] + matrixParameterInterface.getParameterValue(i, j));
                    }
                }
            }
        }
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected void storeState() {
        if (this.count != null) {
            System.arraycopy(this.count, 0, this.storedCount, 0, this.count.length);
        }
    }

    @Override
    protected void restoreState() {
        int[] nArray = this.storedCount;
        this.storedCount = this.count;
        this.count = nArray;
    }

    @Override
    protected void acceptState() {
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    public Model getModel() {
        return this;
    }

    @Override
    public double getLogLikelihood() {
        if (this.DPP != null) {
            return this.poisson.logPdf(this.DPP.getSum()) - Math.log(1.0 - Math.exp(-this.poisson.mean()));
        }
        if (this.count != null) {
            if (this.parameter != null && !(this.parameter instanceof AdaptableSizeFastMatrixParameter)) {
                int n;
                int n2;
                if (!this.transpose) {
                    this.count = new int[this.parameter.getColumnDimension()];
                    this.storedCount = new int[this.parameter.getColumnDimension()];
                    for (n2 = 0; n2 < this.count.length; ++n2) {
                        for (n = 0; n < this.parameter.getRowDimension(); ++n) {
                            int n3 = n2;
                            this.count[n3] = (int)((double)this.count[n3] + this.parameter.getParameterValue(n, n2));
                        }
                    }
                } else {
                    this.count = new int[this.parameter.getRowDimension()];
                    this.storedCount = new int[this.parameter.getRowDimension()];
                    for (n2 = 0; n2 < this.count.length; ++n2) {
                        for (n = 0; n < this.parameter.getColumnDimension(); ++n) {
                            int n4 = n2;
                            this.count[n4] = (int)((double)this.count[n4] + this.parameter.getParameterValue(n2, n));
                        }
                    }
                }
            }
            double d = 0.0;
            for (int i = 0; i < this.count.length; ++i) {
                if (this.count[i] != 0) {
                    d += 1.0;
                }
                if (this.count[i] >= 0) continue;
                throw new RuntimeException("Less than 0 elements are 0. Check for an error");
            }
            return this.poisson.logPdf(d) - Math.log(1.0 - Math.exp(-this.poisson.mean()));
        }
        if (!this.transpose) {
            return this.poisson.logPdf(this.parameter.getRowDimension()) - Math.log(1.0 - Math.exp(-this.poisson.mean()));
        }
        return this.poisson.logPdf(this.parameter.getColumnDimension()) - Math.log(1.0 - Math.exp(-this.poisson.mean()));
    }

    @Override
    public void makeDirty() {
    }

    @Override
    public double getSizeLogLikelihood() {
        return this.getLogLikelihood();
    }
}

