/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.tree;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeUtils;
import dr.evolution.util.TaxonList;
import dr.evomodel.tree.DefaultTreeModel;
import dr.evomodel.tree.TreeStatistic;
import java.util.Set;

public class MRCATraitStatistic
extends TreeStatistic {
    private DefaultTreeModel tree = null;
    private Set<String> leafSet = null;
    private String trait;
    private boolean isRate;

    public MRCATraitStatistic(String string, String string2, DefaultTreeModel defaultTreeModel, TaxonList taxonList) throws TreeUtils.MissingTaxonException {
        super(string);
        this.tree = defaultTreeModel;
        this.trait = string2;
        this.leafSet = TreeUtils.getLeavesForTaxa(defaultTreeModel, taxonList);
        this.isRate = string2.equals("rate");
    }

    @Override
    public void setTree(Tree tree) {
        this.tree = (DefaultTreeModel)tree;
    }

    @Override
    public Tree getTree() {
        return this.tree;
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public double getStatisticValue(int n) {
        NodeRef nodeRef = TreeUtils.getCommonAncestorNode(this.tree, this.leafSet);
        if (nodeRef == null) {
            throw new RuntimeException("No node found that is MRCA of " + this.leafSet);
        }
        if (this.isRate) {
            return this.tree.getNodeRate(nodeRef);
        }
        return this.tree.getNodeTrait(nodeRef, this.trait);
    }
}

