/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jclec.selector;

import net.sf.jclec.IIndividual;
import net.sf.jclec.ISystem;
import net.sf.jclec.fitness.IValueFitness;
import net.sf.jclec.selector.StochasticSelector;
import org.apache.commons.lang.builder.EqualsBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RouletteSelector<I extends IIndividual>
extends StochasticSelector<I> {
    private static final long serialVersionUID = -7486679623259737868L;
    protected transient double[] roulette;

    public RouletteSelector() {
    }

    public RouletteSelector(ISystem<I> context) {
        super(context);
    }

    @Override
    protected void prepareSelection() {
        if (this.roulette == null || this.roulette.length != this.actsrcsz) {
            this.roulette = new double[this.actsrcsz];
        }
        double acc = 0.0;
        int idx = 0;
        for (IIndividual ind : this.actsrc) {
            this.roulette[idx++] = acc += ((IValueFitness)ind.getFitness()).getValue();
        }
        while (idx > 0) {
            if (acc != 0.0) {
                int n = --idx;
                this.roulette[n] = this.roulette[n] / acc;
                continue;
            }
            --idx;
        }
    }

    @Override
    protected I selectNext() {
        double value = this.randgen.raw();
        int i = 0;
        while (i < this.actsrcsz) {
            if (value < this.roulette[i]) {
                return (I)((IIndividual)this.actsrc.get(i));
            }
            ++i;
        }
        return (I)((IIndividual)this.actsrc.get(this.randgen.choose(0, this.roulette.length - 1)));
    }

    public boolean equals(Object other) {
        if (other instanceof RouletteSelector) {
            RouletteSelector o = (RouletteSelector)other;
            EqualsBuilder eb = new EqualsBuilder();
            eb.append(this.randgen, o.randgen);
            return eb.isEquals();
        }
        return false;
    }
}

