/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Genetic_Rule_Learning.M5Rules;

import keel.Algorithms.Genetic_Rule_Learning.M5Rules.M5TreeNode;
import keel.Algorithms.Genetic_Rule_Learning.M5Rules.MyDataset;
import keel.Algorithms.Genetic_Rule_Learning.M5Rules.parseParameters;

public final class M5 {
    private M5TreeNode[] m_root;
    private boolean m_UseUnsmoothed = false;
    private double m_PruningFactor = 2.0;
    private int m_Model = 3;
    private int m_Verbosity = 0;
    public static final int MODEL_LINEAR_REGRESSION = 1;
    public static final int MODEL_REGRESSION_TREE = 2;
    public static final int MODEL_MODEL_TREE = 3;
    MyDataset trainDataset;
    MyDataset valDataset;
    MyDataset testDataset;

    public M5(parseParameters paramFile) throws Exception {
        String trainFileName = paramFile.getTrainingInputFile();
        String valFileName = paramFile.getValidationInputFile();
        String testFileName = paramFile.getTestInputFile();
        this.m_Model = 3;
        this.m_PruningFactor = Double.parseDouble(paramFile.getParameter(0));
        this.m_UseUnsmoothed = Boolean.valueOf(paramFile.getParameter(1));
        this.m_Verbosity = Integer.parseInt(paramFile.getParameter(2));
        if (this.m_PruningFactor < 0.0 || this.m_PruningFactor > 10.0) {
            this.m_PruningFactor = 2.0;
            System.err.println("Error: Pruning Factor must be in the interval [0,10]");
            System.err.println("Using default value: 2");
        }
        if (this.m_Verbosity < 0 || this.m_Verbosity > 2) {
            this.m_Verbosity = 0;
            System.err.println("Error: Verbosity must be 0, 1 or 2");
            System.err.println("Using default value: 0");
        }
        this.trainDataset = new MyDataset(trainFileName, true);
        this.valDataset = new MyDataset(valFileName, false);
        this.testDataset = new MyDataset(testFileName, false);
        if (this.trainDataset.getClassAttribute().isDiscret()) {
            throw new Exception("Class has to be numeric.");
        }
        this.buildClassifier(this.trainDataset);
    }

    public M5(MyDataset data, double prune_factor, boolean unsmoothed, int verbosity) throws Exception {
        this.m_Model = 3;
        this.m_PruningFactor = prune_factor;
        this.m_UseUnsmoothed = unsmoothed;
        this.m_Verbosity = verbosity;
        if (this.m_PruningFactor < 0.0 || this.m_PruningFactor > 10.0) {
            this.m_PruningFactor = 2.0;
            System.err.println("Error: Pruning Factor must be in the interval [0,10]");
            System.err.println("Using default value: 2");
        }
        if (this.m_Verbosity < 0 || this.m_Verbosity > 2) {
            this.m_Verbosity = 0;
            System.err.println("Error: Verbosity must be 0, 1 or 2");
            System.err.println("Using default value: 0");
        }
        if (data.getClassAttribute().isDiscret()) {
            throw new Exception("Class has to be numeric.");
        }
        this.buildClassifier(data);
    }

    public final void buildClassifier(MyDataset inst) throws Exception {
        inst = inst.discretToBinary();
        this.m_root = new M5TreeNode[2];
        double deviation = M5.stdDev(inst.getClassIndex(), inst);
        this.m_root[0] = new M5TreeNode(inst, null, this.m_Model, this.m_PruningFactor, deviation);
        this.m_root[0].split(inst);
        this.m_root[0].numLeaves(0);
        this.m_root[1] = this.m_root[0].copy(null);
        this.m_root[1].prune();
        if (!this.m_UseUnsmoothed) {
            this.m_root[1].smoothen();
            this.m_root[1].numLeaves(0);
        }
    }

    public String[] getOptions() {
        String[] options = new String[7];
        int current = 0;
        switch (this.m_Model) {
            case 3: {
                options[current++] = "-O";
                options[current++] = "m";
                if (!this.m_UseUnsmoothed) break;
                options[current++] = "-U";
                break;
            }
            case 2: {
                options[current++] = "-O";
                options[current++] = "r";
                break;
            }
            case 1: {
                options[current++] = "-O";
                options[current++] = "l";
            }
        }
        options[current++] = "-F";
        options[current++] = "" + this.m_PruningFactor;
        options[current++] = "-V";
        options[current++] = "" + this.m_Verbosity;
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    public final String toString() {
        try {
            StringBuffer text = new StringBuffer();
            double absDev = M5.absDev(this.m_root[0].itemsets.getClassIndex(), this.m_root[0].itemsets);
            if (this.m_Verbosity >= 1 && this.m_Model != 1) {
                switch (this.m_root[0].model) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        text.append("@Unpruned training regression tree:\n");
                        break;
                    }
                    case 3: {
                        text.append("@Unpruned training model tree:\n");
                    }
                }
                if (!this.m_root[0].type) {
                    text.append("\n");
                }
                text.append(this.m_root[0].treeToString(0, absDev) + "\n");
                text.append("@Models at the leaves:\n\n");
                text.append(this.m_root[0].formulaeToString(false) + "\n");
            }
            if (this.m_root[0].model != 1) {
                switch (this.m_root[0].model) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        text.append("@Pruned training regression tree:\n");
                        break;
                    }
                    case 3: {
                        text.append("@Pruned training model tree:\n");
                    }
                }
                if (!this.m_root[1].type) {
                    text.append("\n");
                }
                text.append(this.m_root[1].treeToString(0, absDev) + "\n");
                text.append("@Models at the leaves:\n");
                if (this.m_root[0].model != 1 && this.m_UseUnsmoothed) {
                    text.append("@Unsmoothed linear models at the leaves of the pruned tree (simple):\n");
                    text.append(this.m_root[1].formulaeToString(false) + "\n");
                }
                if (this.m_root[0].model == 3 && !this.m_UseUnsmoothed) {
                    text.append("@Smoothed linear models at the leaves of the pruned tree (complex):\n");
                    text.append(this.m_root[1].formulaeToString(true) + "\n");
                }
            } else {
                text.append("@Training linear regression model:\n");
                text.append(this.m_root[1].unsmoothed.toString(this.m_root[1].itemsets, 0) + "\n\n");
            }
            text.append("@Number of Rules: " + this.m_root[1].numberOfLinearModels());
            return text.toString();
        }
        catch (Exception e) {
            return "can't print m5' tree";
        }
    }

    public double measureNumLinearModels() {
        return this.m_root[1].numberOfLinearModels();
    }

    public double measureNumLeaves() {
        return this.measureNumLinearModels();
    }

    public double measureNumRules() {
        return this.measureNumLinearModels();
    }

    public double getMeasure(String additionalMeasureName) {
        if (additionalMeasureName.compareTo("measureNumRules") == 0) {
            return this.measureNumRules();
        }
        if (additionalMeasureName.compareTo("measureNumLinearModels") == 0) {
            return this.measureNumLinearModels();
        }
        if (additionalMeasureName.compareTo("measureNumLeaves") == 0) {
            return this.measureNumLeaves();
        }
        throw new IllegalArgumentException(additionalMeasureName + " not supported (M5)");
    }

    public boolean getUseUnsmoothed() {
        return this.m_UseUnsmoothed;
    }

    public void setUseUnsmoothed(boolean v) {
        this.m_UseUnsmoothed = v;
    }

    public double getPruningFactor() {
        return this.m_PruningFactor;
    }

    public void setPruningFactor(double v) {
        this.m_PruningFactor = v;
    }

    public M5TreeNode getTree() {
        return this.m_root[1];
    }

    public int getVerbosity() {
        return this.m_Verbosity;
    }

    public void setVerbosity(int v) {
        this.m_Verbosity = v;
    }

    public static final boolean hasEnumAttr(MyDataset inst) {
        boolean b = false;
        for (int j = 0; j < inst.numAttributes(); ++j) {
            if (!inst.getAttribute(j).isDiscret()) continue;
            b = true;
        }
        return b;
    }

    public static final boolean hasMissing(MyDataset inst) {
        boolean b = false;
        for (int i = 0; i < inst.numItemsets(); ++i) {
            for (int j = 0; j < inst.numAttributes(); ++j) {
                if (!inst.itemset(i).isMissing(j)) continue;
                b = true;
            }
        }
        return b;
    }

    public static final double sum(int attr, MyDataset inst) {
        double sum = 0.0;
        for (int i = 0; i <= inst.numItemsets() - 1; ++i) {
            sum += inst.itemset(i).getValue(attr);
        }
        return sum;
    }

    public static final double sqrSum(int attr, MyDataset inst) {
        double sqrSum = 0.0;
        for (int i = 0; i <= inst.numItemsets() - 1; ++i) {
            double value = inst.itemset(i).getValue(attr);
            sqrSum += value * value;
        }
        return sqrSum;
    }

    public static final double stdDev(int attr, MyDataset inst) {
        double sd;
        int count = 0;
        double sum = 0.0;
        double sqrSum = 0.0;
        for (int i = 0; i <= inst.numItemsets() - 1; ++i) {
            ++count;
            double value = inst.itemset(i).getValue(attr);
            sum += value;
            sqrSum += value * value;
        }
        if (count > 1) {
            double va = (sqrSum - sum * sum / (double)count) / (double)count;
            va = Math.abs(va);
            sd = Math.sqrt(va);
        } else {
            sd = 0.0;
        }
        return sd;
    }

    public static final double absDev(int attr, MyDataset inst) {
        double absDev;
        int i;
        double average = 0.0;
        double absdiff = 0.0;
        for (i = 0; i <= inst.numItemsets() - 1; ++i) {
            average += inst.itemset(i).getValue(attr);
        }
        if (inst.numItemsets() > 1) {
            average /= (double)inst.numItemsets();
            for (i = 0; i <= inst.numItemsets() - 1; ++i) {
                absdiff += Math.abs(inst.itemset(i).getValue(attr) - average);
            }
            absDev = absdiff / (double)inst.numItemsets();
        } else {
            absDev = 0.0;
        }
        return absDev;
    }

    public static final double variance(int attr, MyDataset inst) {
        int count = 0;
        double sum = 0.0;
        double sqrSum = 0.0;
        for (int i = 0; i <= inst.numItemsets() - 1; ++i) {
            double value = inst.itemset(i).getValue(attr);
            sum += value;
            sqrSum += value * value;
            ++count;
        }
        double va = count > 0 ? (sqrSum - sum * sum / (double)count) / (double)count : 0.0;
        return va;
    }

    public static final long roundDouble(double value) {
        long roundedValue = value > 0.0 ? (long)(value + 0.5) : -((long)(Math.abs(value) + 0.5));
        return roundedValue;
    }

    public static final long floorDouble(double value) {
        long floorValue = value > 0.0 ? (long)value : -((long)(Math.abs(value) + 1.0));
        return floorValue;
    }

    public static final String doubleToStringF(double value, int width, int afterDecimalPoint) {
        int i;
        StringBuffer stringBuffer;
        String resultString;
        if (afterDecimalPoint < 0) {
            afterDecimalPoint = 0;
        }
        long precisionValue = 0L;
        double temp = value * Math.pow(10.0, afterDecimalPoint);
        if (Math.abs(temp) < 9.223372036854776E18) {
            precisionValue = M5.roundDouble(temp);
            if (precisionValue == 0L) {
                resultString = String.valueOf(0);
                stringBuffer = new StringBuffer(resultString);
                stringBuffer.append(".");
                for (i = 1; i <= afterDecimalPoint; ++i) {
                    stringBuffer.append("0");
                }
                resultString = stringBuffer.toString();
            } else {
                int dotPosition;
                resultString = String.valueOf(precisionValue);
                stringBuffer = new StringBuffer(resultString);
                for (dotPosition = stringBuffer.length() - afterDecimalPoint; dotPosition < 0; ++dotPosition) {
                    stringBuffer.insert(0, 0);
                }
                stringBuffer.insert(dotPosition, ".");
                if (stringBuffer.charAt(0) == '.') {
                    stringBuffer.insert(0, 0);
                }
                resultString = stringBuffer.toString();
            }
        } else {
            resultString = new String("NaN");
        }
        stringBuffer = new StringBuffer(Math.max(width, resultString.length()));
        for (i = 0; i < stringBuffer.capacity() - resultString.length(); ++i) {
            stringBuffer.append(' ');
        }
        stringBuffer.append(resultString);
        return stringBuffer.toString();
    }

    public static final String doubleToStringG(double value, int width, int precision) {
        int i;
        StringBuffer stringBuffer;
        String resultString;
        double temp;
        int exponent = 0;
        if (precision <= 0) {
            precision = 1;
        }
        long precisionValue = 0L;
        exponent = 0;
        if (value != 0.0 && precision - 1 != (int)(Math.log((double)Math.abs(precisionValue = M5.roundDouble(temp = value * Math.pow(10.0, precision - (exponent = (int)M5.floorDouble(Math.log(Math.abs(value)) / Math.log(10.0))) - 1))) + 0.5) / Math.log(10.0))) {
            ++exponent;
            precisionValue = M5.roundDouble((double)precisionValue / 10.0);
        }
        if (precisionValue == 0L) {
            resultString = String.valueOf("0");
        } else {
            int dotPosition = precisionValue >= 0L ? 1 : 2;
            if (exponent < -3 || precision - 1 + exponent > 7) {
                resultString = String.valueOf(precisionValue);
                stringBuffer = new StringBuffer(resultString);
                stringBuffer.insert(dotPosition, ".");
                stringBuffer = M5.deleteTrailingZerosAndDot(stringBuffer);
                stringBuffer.append("e").append(String.valueOf(exponent));
                resultString = stringBuffer.toString();
            } else {
                resultString = String.valueOf(precisionValue);
                stringBuffer = new StringBuffer(resultString);
                for (i = 1; i <= -exponent; ++i) {
                    stringBuffer.insert(dotPosition - 1, "0");
                }
                if (exponent <= -1) {
                    stringBuffer.insert(dotPosition, ".");
                } else if (exponent <= precision - 1) {
                    stringBuffer.insert(dotPosition + exponent, ".");
                } else {
                    for (i = 1; i <= exponent - (precision - 1); ++i) {
                        stringBuffer.append("0");
                    }
                    stringBuffer.append(".");
                }
                stringBuffer = M5.deleteTrailingZerosAndDot(stringBuffer);
                resultString = stringBuffer.toString();
            }
        }
        stringBuffer = new StringBuffer(Math.max(width, resultString.length()));
        for (i = 0; i < stringBuffer.capacity() - resultString.length(); ++i) {
            stringBuffer.append(' ');
        }
        stringBuffer.append(resultString);
        return stringBuffer.toString();
    }

    public static final StringBuffer deleteTrailingZerosAndDot(StringBuffer stringBuffer) {
        while (stringBuffer.charAt(stringBuffer.length() - 1) == '0' || stringBuffer.charAt(stringBuffer.length() - 1) == '.') {
            if (stringBuffer.charAt(stringBuffer.length() - 1) == '0') {
                stringBuffer.setLength(stringBuffer.length() - 1);
                continue;
            }
            stringBuffer.setLength(stringBuffer.length() - 1);
            break;
        }
        return stringBuffer;
    }

    public static final double smoothenValue(double p, double q, int n, int k) {
        return ((double)n * p + (double)k * q) / (double)(n + k);
    }

    public static final double correlation(double[] y1, double[] y2, int n) {
        int i;
        double av1 = 0.0;
        double av2 = 0.0;
        double y11 = 0.0;
        double y22 = 0.0;
        double y12 = 0.0;
        if (n <= 1) {
            return 1.0;
        }
        for (i = 0; i < n; ++i) {
            av1 += y1[i];
            av2 += y2[i];
        }
        av1 /= (double)n;
        av2 /= (double)n;
        for (i = 0; i < n; ++i) {
            y11 += (y1[i] - av1) * (y1[i] - av1);
            y22 += (y2[i] - av2) * (y2[i] - av2);
            y12 += (y1[i] - av1) * (y2[i] - av2);
        }
        double c = y11 * y22 == 0.0 ? 1.0 : y12 / Math.sqrt(Math.abs(y11 * y22));
        return c;
    }

    public static final boolean eqDouble(double a, double b) {
        if (Math.abs(a) < 1.0E-10 && Math.abs(b) < 1.0E-10) {
            return true;
        }
        double c = Math.abs(a) + Math.abs(b);
        return Math.abs(a - b) < c * 1.0E-10;
    }

    public static final void errorMsg(String err) {
        System.out.print("Error: ");
        System.out.println(err);
        System.exit(1);
    }
}

