/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Neural_Networks.NNEP_Clas.problem.classification.softmax;

import java.util.Comparator;
import java.util.List;
import keel.Algorithms.Neural_Networks.NNEP_Clas.problem.classification.IClassifier;
import keel.Algorithms.Neural_Networks.NNEP_Clas.problem.classification.softmax.ISoftmaxClassifier;
import keel.Algorithms.Neural_Networks.NNEP_Common.data.DoubleTransposedDataSet;
import keel.Algorithms.Neural_Networks.NNEP_Common.problem.ProblemEvaluator;
import keel.Algorithms.Neural_Networks.NNEP_Common.problem.errorfunctions.IErrorFunction;
import net.sf.jclec.IConfigure;
import net.sf.jclec.IFitness;
import net.sf.jclec.base.AbstractIndividual;
import net.sf.jclec.fitness.ValueFitnessComparator;

public abstract class ClassificationProblemEvaluator
extends ProblemEvaluator<AbstractIndividual<? extends ISoftmaxClassifier>>
implements IConfigure {
    IErrorFunction<double[][]> defaultErrorFunction;
    protected Comparator<IFitness> comparator = new ValueFitnessComparator(false);

    public double getTrainClassificationError(IClassifier classifier, IErrorFunction<byte[][]> errorFunction) {
        DoubleTransposedDataSet dataset = this.dataNormalized ? this.scaledTrainData : this.unscaledTrainData;
        byte[][] obtained = classifier.classify(dataset.getAllInputs());
        double[][] doubleExpected = dataset.getAllOutputs();
        byte[][] expected = new byte[doubleExpected.length][doubleExpected[0].length];
        for (int i = 0; i < doubleExpected.length; ++i) {
            for (int j = 0; j < doubleExpected[i].length; ++j) {
                expected[i][j] = (byte)doubleExpected[i][j];
            }
        }
        double error = errorFunction.calculateError(obtained, expected);
        return error;
    }

    public double getTestClassificationError(IClassifier classifier, IErrorFunction<byte[][]> errorFunction) {
        DoubleTransposedDataSet dataset = this.dataNormalized ? this.scaledTestData : this.unscaledTestData;
        byte[][] obtained = classifier.classify(dataset.getAllInputs());
        double[][] doubleExpected = dataset.getAllOutputs();
        byte[][] expected = new byte[doubleExpected.length][doubleExpected[0].length];
        for (int i = 0; i < doubleExpected.length; ++i) {
            for (int j = 0; j < doubleExpected[i].length; ++j) {
                expected[i][j] = (byte)doubleExpected[i][j];
            }
        }
        double error = errorFunction.calculateError(obtained, expected);
        return error;
    }

    public double[] getTrainClassificationBehaviorArray(IClassifier classifier) {
        DoubleTransposedDataSet dataset = this.dataNormalized ? this.scaledTrainData : this.unscaledTrainData;
        double[] result = new double[dataset.getNofobservations()];
        byte[][] obtained = classifier.classify(dataset.getAllInputs());
        double[][] expected = dataset.getAllOutputs();
        for (int j = 0; j < dataset.getNofobservations(); ++j) {
            result[j] = 1.0;
        }
        for (int o = 0; o < obtained.length; ++o) {
            for (int e = 0; e < obtained[o].length; ++e) {
                if ((double)obtained[o][e] == expected[o][e] || result[e] != 1.0) continue;
                result[e] = 0.0;
            }
        }
        return result;
    }

    public double[] getTestClassificationBehaviorArray(IClassifier classifier) {
        DoubleTransposedDataSet dataset = this.dataNormalized ? this.scaledTestData : this.unscaledTestData;
        double[] result = new double[dataset.getNofobservations()];
        byte[][] obtained = classifier.classify(dataset.getAllInputs());
        double[][] expected = dataset.getAllOutputs();
        for (int j = 0; j < dataset.getNofobservations(); ++j) {
            result[j] = 1.0;
        }
        for (int o = 0; o < obtained.length; ++o) {
            for (int e = 0; e < obtained[o].length; ++e) {
                if ((double)obtained[o][e] == expected[o][e] || result[e] != 1.0) continue;
                result[e] = 0.0;
            }
        }
        return result;
    }

    public double[][] getTrainClassificationBehaviorMatrix(IClassifier classifier1, IClassifier classifier2) {
        int i;
        double[][] result = new double[2][2];
        double[] behavior1 = this.getTrainClassificationBehaviorArray(classifier1);
        double[] behavior2 = this.getTrainClassificationBehaviorArray(classifier2);
        for (i = 0; i < result.length; ++i) {
            for (int j = 0; j < result[i].length; ++j) {
                result[i][j] = 0.0;
            }
        }
        for (i = 0; i < behavior1.length; ++i) {
            if (behavior1[i] == 1.0 && behavior2[i] == 1.0) {
                double[] dArray = result[0];
                dArray[0] = dArray[0] + 1.0;
                continue;
            }
            if (behavior1[i] == 1.0 && behavior2[i] == 0.0) {
                double[] dArray = result[0];
                dArray[1] = dArray[1] + 1.0;
                continue;
            }
            if (behavior1[i] == 0.0 && behavior2[i] == 1.0) {
                double[] dArray = result[1];
                dArray[0] = dArray[0] + 1.0;
                continue;
            }
            if (behavior1[i] != 0.0 || behavior2[i] != 0.0) continue;
            double[] dArray = result[1];
            dArray[1] = dArray[1] + 1.0;
        }
        return result;
    }

    public double[][] getTestClassificationBehaviorMatrix(IClassifier classifier1, IClassifier classifier2) {
        int i;
        double[][] result = new double[2][2];
        double[] behavior1 = this.getTestClassificationBehaviorArray(classifier1);
        double[] behavior2 = this.getTestClassificationBehaviorArray(classifier2);
        for (i = 0; i < result.length; ++i) {
            for (int j = 0; j < result[i].length; ++j) {
                result[i][j] = 0.0;
            }
        }
        for (i = 0; i < behavior1.length; ++i) {
            if (behavior1[i] == 1.0 && behavior2[i] == 1.0) {
                double[] dArray = result[0];
                dArray[0] = dArray[0] + 1.0;
                continue;
            }
            if (behavior1[i] == 1.0 && behavior2[i] == 0.0) {
                double[] dArray = result[0];
                dArray[1] = dArray[1] + 1.0;
                continue;
            }
            if (behavior1[i] == 0.0 && behavior2[i] == 1.0) {
                double[] dArray = result[1];
                dArray[0] = dArray[0] + 1.0;
                continue;
            }
            if (behavior1[i] != 0.0 || behavior2[i] != 0.0) continue;
            double[] dArray = result[1];
            dArray[1] = dArray[1] + 1.0;
        }
        return result;
    }

    public double getTrainQStatistic(IClassifier classifier1, IClassifier classifier2) {
        double[][] matrix = this.getTrainClassificationBehaviorMatrix(classifier1, classifier2);
        double term1 = matrix[1][1] * matrix[0][0];
        double term2 = matrix[0][1] * matrix[1][0];
        return (term1 - term2) / (term1 + term2);
    }

    public double getTestQStatistic(IClassifier classifier1, IClassifier classifier2) {
        double[][] matrix = this.getTestClassificationBehaviorMatrix(classifier1, classifier2);
        double term1 = matrix[1][1] * matrix[0][0];
        double term2 = matrix[0][1] * matrix[1][0];
        return (term1 - term2) / (term1 + term2);
    }

    public double getTrainQStatistic(List<IClassifier> classifiers) {
        double result = 0.0;
        double nOfClassifiers = classifiers.size();
        for (int i = 0; i < classifiers.size() - 1; ++i) {
            for (int j = i + 1; j < classifiers.size(); ++j) {
                result += this.getTrainQStatistic(classifiers.get(i), classifiers.get(j));
            }
        }
        return 2.0 / (nOfClassifiers * (nOfClassifiers - 1.0)) * result;
    }

    public double getTestQStatistic(List<IClassifier> classifiers) {
        double result = 0.0;
        double nOfClassifiers = classifiers.size();
        for (int i = 0; i < classifiers.size() - 1; ++i) {
            for (int j = i + 1; j < classifiers.size(); ++j) {
                result += this.getTestQStatistic(classifiers.get(i), classifiers.get(j));
            }
        }
        return 2.0 / (nOfClassifiers * (nOfClassifiers - 1.0)) * result;
    }
}

